
###############################################################################
##                                                                           ##
##    Copyright (c) 1995 - 2009 by Steffen Beyer.                            ##
##    All rights reserved.                                                   ##
##                                                                           ##
##    This package is free software; you can redistribute it                 ##
##    and/or modify it under the same terms as Perl itself.                  ##
##                                                                           ##
###############################################################################

package Bit::Vector;

use strict;
use vars qw(@ISA @EXPORT @EXPORT_OK $VERSION @CONFIG);

require Exporter;
require DynaLoader;

@ISA = qw(Exporter DynaLoader);

@EXPORT = qw();

@EXPORT_OK = qw();

$VERSION = '6.8';

bootstrap Bit::Vector $VERSION;

sub STORABLE_freeze
{
    my($self, $clone) = @_;
    return( Storable::freeze( [ $self->Size(), $self->Block_Read() ] ) );
}

sub STORABLE_thaw
{
    my($self, $clone, $string) = @_;
    my($size,$buffer) = @{ Storable::thaw($string) };
    $self->Unfake($size); # Undocumented new feature (slightly dangerous!) - for use by Storable only!
    $self->Block_Store($buffer);
}

#sub STORABLE_attach # Does not work properly in nested data structures (see test cases)
#{
#    my($class, $clone, $string) = @_;
#    my($size,$buffer) = @{ Storable::thaw($string) };
#    my $self = Bit::Vector->new($size);
#    $self->Block_Store($buffer);
#    return $self;
#}

1;

__END__

