use strict;
use warnings;

use lib qw(../lib);
use ModPerl::BuildMM ();
require ModPerl::Code;
use Apache::Build ();

my $build = ModPerl::BuildMM::build_config();

my $srcdir = '../../../src/modules/perl';
my @names = ModPerl::Code::src_apr_ext();

my(@obj, @clean, %src);
for (@names) {
    push @obj, join '.', $_, 'o';
    my $cfile = join '.', $_, 'c';
    push @clean, $cfile;
    $src{$cfile} = "$srcdir/$cfile";
}

my @skip = qw(dynamic test);
push @skip, q{static}
    unless (Apache::Build::BUILD_APREXT);

my %args = (NAME          => 'lib' . $build->{MP_APR_LIB},
            VERSION_FROM  => '../APR/APR.pm',
            SKIP          =>  [ @skip ] ,
            LINKTYPE      =>  'static',
            OBJECT        => "@obj",
            clean         => { FILES => "@clean" },
	   );

ModPerl::BuildMM::WriteMakefile(%args);

# avoid redefined warnings from imported postamble symbol from
# elsewhere in other Makefile.PL files
no warnings 'redefine';
sub MY::postamble {
    my $self = shift;
    my $string = $self->ModPerl::BuildMM::MY::postamble;

    $string .= join '', map {
        "$_: $src{$_}\n\t\$(CP) $src{$_} .\n";
    } keys %src;
    return $string;
}
