package JSP::PerlObject;
# Documentation only
1;

__END__

=head1 NAME

JSP::PerlObject - Encapsulates generic perl objects in javascript

=head1 DESCRIPTION

When a perl object enters javascript land JSP's engine will select the
kind of wrapper needed for it.  If the object belongs to a javascript class
created by L<JSP::Context/bind_class> it becomes an instance of that
class. Otherwise it becomes an instance of the generic wrapper class
C<PerlObject>.

Wrapper classes, installed with C<bind_class>, define all the semantic for
objects wrapped in them. So, you should check their documentation on how to use
them.  This page describes the semantics of the generic wrapper.

=head1 JAVASCRIPT INTERFACE

Instances of C<PerlObject> behave much like any other javascript object.  You
can get and set its properties and you can call its methods.

You can even extend them adding new properties and methods. You can override
its methods with new ones writen as javascript functions.

They inherit from Object (via its prototype chain). You can use any of the
functions from C<Object.prototype>.

In fact, the C<PerlObject> wrapper is writen as transparent as posible to avoid
name clashes with the methods and properties of the associated perl object nor
affect the expected javascript semantics.

Be aware that any changes you made to the instance will not normally be visible
in perl land. And that's a good thing and expected behavior: If you override
some method to implement an especific workarraund for something too 'perlish',
you are changing your instance for javascript only, perl land will continue
using the 'perlish' original method.

=head2 Instance properties

All properties defined in the associated perl object are available as
properties in javascript.

When you reference a property of a C<PerlObject> instance it will be obtain
from the perl side, wrapped or converted acording to is type, see
L<JSP/"From perl to javascript">. Unless you have override on javascript that property, of course.

The only instance property of especial interest is:

=over 4

=item __proto__

Every object in SpiderMonkey's javascript has a readonly property named
C<__proto__>. The head of the I<prototype chain> of the object. In it
the JSP module implements PerlObject's magic. Here you will see an
instance of I<Stash proxy>, that associates the PerlObject with the
original perl package (a "stash" in perl parlance) in which the object was
I<blessed>.  See L<JSP::Stash> for the details.

=back

=head2 Instance methods

Any instance methods defined in the associated perl object and its inheritance
C<@ISA> tree.

When you call a method of a C<PerlObject> instance you are referencing a
property in it, so acordly to the previous section you will obtain a C<PerlSub>
instance. So that C<PerlSub> instance will be called. See
L<JSP::PerlSub> for the details.
