# NAME

Interact::Later - Delay some tasks for later.

# VERSION

Version 0.03

# SYNOPSIS

Can be used typically when you receive lots of POST requests that you don't want
to proceed right now. This module will fastly store the data content on disk
without the need to use a database.

    use Interact::Later;

    my $delayer = Interact::Later->new(
      cache_path => './cache/',
      file_extension => '.dmp'
    );

    $delayer->write_data_to_disk($data);

    # Later...
    $delayer->clean_cache;

# EXPORT

A list of functions that can be exported.  You can delete this section
if you don't export anything, such as for a purely object-oriented module.

# SUBROUTINES/METHODS

## get\_oldest\_file\_in\_the\_cache

Retrieve the oldest file in the cache

## clean\_cache

## generate\_uuid

## write\_data\_to\_disk

Writes the cache files to disk using `Storable`. It also checks that the cache
path exists and if not, it creates it.

## retrieve\_data\_from\_disk

# AUTHOR

Sébastien Feugère, `<smonff at riseup.net>`

# BUGS

Please report any bugs or feature requests to `bug-interact-later at rt.cpan.org`, or through
the web interface at [http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Interact-Later](http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Interact-Later).  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.

# SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Interact::Later

You can also look for information at:

- Gitlab: Gitlab issues tracker (report bugs here)

    [http://gitlab.com/smonff/Interact-Later](http://gitlab.com/smonff/Interact-Later)

- AnnoCPAN: Annotated CPAN documentation

    [http://annocpan.org/dist/Interact-Later](http://annocpan.org/dist/Interact-Later)

- CPAN Ratings

    [http://cpanratings.perl.org/d/Interact-Later](http://cpanratings.perl.org/d/Interact-Later)

- Search CPAN

    [http://search.cpan.org/dist/Interact-Later/](http://search.cpan.org/dist/Interact-Later/)

# ACKNOWLEDGEMENTS

# LICENSE AND COPYRIGHT

Copyright 2019 Sébastien Feugère.

This program is free software; you can redistribute it and/or modify it
under the terms of the the Artistic License (2.0). You may obtain a
copy of the full license at:

[http://www.perlfoundation.org/artistic\_license\_2\_0](http://www.perlfoundation.org/artistic_license_2_0)

Any use, modification, and distribution of the Standard or Modified
Versions is governed by this Artistic License. By using, modifying or
distributing the Package, you accept this license. Do not use, modify,
or distribute the Package, if you do not accept this license.

If your Modified Version has been derived from a Modified Version made
by someone other than you, you are nevertheless required to ensure that
your Modified Version complies with the requirements of this license.

This license does not grant you the right to use any trademark, service
mark, tradename, or logo of the Copyright Holder.

This license includes the non-exclusive, worldwide, free-of-charge
patent license to make, have made, use, offer to sell, sell, import and
otherwise transfer the Package with respect to any patent claims
licensable by the Copyright Holder that are necessarily infringed by the
Package. If you institute patent litigation (including a cross-claim or
counterclaim) against any party alleging that the Package constitutes
direct or contributory patent infringement, then this Artistic License
to you shall terminate on the date that such litigation is filed.

Disclaimer of Warranty: THE PACKAGE IS PROVIDED BY THE COPYRIGHT HOLDER
AND CONTRIBUTORS "AS IS' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE, OR NON-INFRINGEMENT ARE DISCLAIMED TO THE EXTENT PERMITTED BY
YOUR LOCAL LAW. UNLESS REQUIRED BY LAW, NO COPYRIGHT HOLDER OR
CONTRIBUTOR WILL BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, OR
CONSEQUENTIAL DAMAGES ARISING IN ANY WAY OUT OF THE USE OF THE PACKAGE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
