// ************************************************************************* 
// Copyright (c) 2014, SUSE LLC
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// 
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
// 
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
// 
// 3. Neither the name of SUSE LLC nor the names of its contributors may be
// used to endorse or promote products derived from this software without
// specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
// ************************************************************************* 
//
// main.js
//
// Entry point to JavaScript side; displays the application frame in the
// browser window and passes off control either to the login dialog or 
// the main menu, depending on what session data is passed in from the
// Perl side
//
"use strict";

define ([
    'jquery',
    'cf',
    'current-user',
    'html', 
    'login-dialog',
    'app/target-init',
    'target'
], function (
    $,
    cf,
    currentUser,
    html, 
    loginDialog,
    targetInit,
    target
) {

    var dummy = Object.create(null),
        cu,
        t;

    //
    // throw up HTML body
    //
    $(document.body).html(html.body());

    //
    // initialize targets
    //
    targetInit();
    t = target.pull('demoMenu');

    //
    // mode-specific setup
    //
    console.log( 'connectToRestServer is ' + cf('connectToRestServer') );
    if (cf('connectToRestServer')) {
        console.log( "Derived distribution mode" );
    } else {
        console.log( "Standalone mode" );
    }

    //
    // pass control to main menu or login dialog, as appropriate
    //
    cu = currentUser();
    if (! cf('connectToRestServer') || cu) {
        t.start();
    } else {
        loginDialog();
    }

    // return a dummy object
    return dummy;

});

