package Tie::IxHash::Extension;

use strict;
use warnings;
use List::AllUtils;

{
package Tie::IxHash;

use failures qw/keys::number/;

sub RenameKeys {
	my ($self, @names) = @_;
	failure::keys::number->throw if @names != $self->Length;
	my @values = $self->Values;
	my @new_kv = List::AllUtils::mesh( @names, @values );
	$self->Splice(0, $self->Length, @new_kv);
}


}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Tie::IxHash::Extension

=head1 VERSION

version 0.004_001

=head1 AUTHORS

=over 4

=item *

Zakariyya Mughal <zmughal@cpan.org>

=item *

Stephan Loyd <sloyd@cpan.org>

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014, 2019 by Zakariyya Mughal, Stephan Loyd.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
