#!/usr/bin/perl -T

use lib '.'; use lib 't';

require v5.14.0;

use Cwd;
use Config;
use File::Spec;
use File::Temp qw(tempdir);

my $tname = "d6";

map {
  my $pathdir = $_;
  my $canonpathdir = $pathdir if ((-d $pathdir) and File::Spec->file_name_is_absolute($pathdir));
  ((defined $canonpathdir))?($canonpathdir):()
}
  $ENV{'PERL5LIB'} ? split($Config{path_sep}, $ENV{'PERL5LIB'}) : @INC;

(-f "t/test_dir") && chdir("t");        # run from ..
-f "test_dir"  or die "FATAL: not in test directory?\n";

mkdir ("log", 0755);
-d "log" or die "FATAL: failed to create log dir\n";
chmod (0755, "log"); # set in case log already exists with wrong permissions

use Test::More tests => 2;

ok(1, 'got past init');

my $workdir = tempdir("$tname.XXXXXX", DIR => "log");
die "FATAL: failed to create workdir: $!" unless -d $workdir;
chmod (0755, $workdir); # sometimes tempdir() ignores umask

ok((-d $workdir), 'tempdir test');
