use ExtUtils::MakeMaker;

WriteMakefile(
    NAME         => 'JIRA::REST::Lite',
    VERSION_FROM => 'lib/JIRA/REST/Lite.pm', # finds $VERSION
    ABSTRACT     => 'Lightweight wrapper around Jira\'s REST API with minimal dependencies',
    AUTHOR       => 'Kawamura Shingo <pannakoota@gmail.com>',
    LICENSE      => 'perl',
    PREREQ_PM    => {
        'URI'          => 0,  # URI module is required
        'REST::Client' => 0,  # REST::Client module is required
    },
    dist         => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean        => { FILES    => 'JIRA-REST-Lite-*' },
    META_MERGE   => {
        resources => {
            repository => {
                type => 'git',
                url  => 'https://github.com/kawamurashingo/JIRA-REST-Lite.git',
                web  => 'https://github.com/kawamurashingo/JIRA-REST-Lite',
            },
        },
        prereqs => {
            runtime => {
                requires => {
                    'URI'          => 0,  # Required for handling URI objects
                    'REST::Client' => 0,  # Required for making REST API calls
                },
            },
        },
    },
);

