package Sub::Spec::Clause::result;
BEGIN {
  $Sub::Spec::Clause::result::VERSION = '0.08';
}
# ABSTRACT: Specify sub result

1;


=pod

=head1 NAME

Sub::Spec::Clause::result - Specify sub result

=head1 VERSION

version 0.08

=head1 SYNOPSIS

 # result is an integer
 result => 'int*'

 # result is an integer starting from zero
 result => ['int*' => {ge=>0}]

 # result is an array of records
 result => ['array*' => {
             summary => 'blah blah blah ...',
             of      => ['hash*' => {allowed_keys=>[qw/name age address/]} ]
           }]

=head2 DESCRIPTION

The 'result' clause specifies sub's result value. The value of the clause is a
Sah schema, so refer to L<Data::Sah> for more details on the syntax.

Note that since 'result_naked' by default is false, instead of just returning

 RESULT_VALUE

you'll normally have to return this from your sub:

 [STATUS_CODE, ERR_MSG, RESULT_VALUE]

where STATUS_CODE is a 3-digit number (just like HTTP response status), ERR_MSG
contains error message, and RESULT_VALUE is the actual result.

Example:

 $SPEC{is_palindrome} = {
     summary => 'Check whether a string is a palindrome',
     args    => {str => 'str*'},
     result  => 'bool*',
 };
 sub is_palindrome {
     my %args = @_;
     my $str  = $args{str};
     [200, "OK", $str eq reverse($str) ? 1:0];
 }

Note that the checking of result value is not implemented yet, it will be
implemented by the wrapper code generated by L<Sub::Spec::Exporter>. The wrapper
will only check sub's result if status code is successul (200).

=head1 SEE ALSO

L<Sub::Spec>

L<Data::Sah>

L<Sub::Spec::Clause::args>

=head1 AUTHOR

Steven Haryanto <stevenharyanto@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2011 by Steven Haryanto.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut


__END__

