# -*-Perl-*-
## Bioperl Test Harness Script for Modules
## $Id: TreeBuild.t,v 1.2 2004/01/24 20:16:08 jason Exp $

# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.t'

my $error = 0;

use strict;
BEGIN {
    # to handle systems with no installed Test module
    # we include the t dir (where a copy of Test.pm is located)
    # as a fallback
    eval { require Test; };
    if( $@ ) {
	use lib 't';
    }

    use Test;
    plan tests => 7;
}

if( $error == 1 ) {
    exit(0);
}

my $debug = -1;

use Bio::Align::DNAStatistics;
use Bio::Align::ProteinStatistics;
use Bio::Align::Utilities qw(:all);
use Bio::AlignIO;
use Bio::Root::IO;
use Bio::Tree::DistanceFactory;
use Bio::TreeIO;

my $in = new Bio::AlignIO(-format => 'clustalw',
       			  -file   => Bio::Root::IO->catfile('t', 'data',
							    'pep-266.aln'));
my $aln = $in->next_aln();
ok($aln);
my $pstats = new Bio::Align::ProteinStatistics(-verbose => $debug);
my $matrix = $pstats->distance(-method => 'Kimura',
			       -align  => $aln);
ok($matrix);

my $treebuilder = Bio::Tree::DistanceFactory->new(-method => 'NJ');
my $tree = $treebuilder->make_tree($matrix);
ok($tree);

my ($cn) = $tree->find_node('183.m01790');

# brlens checked against tree generated by PHYLIP NJ
ok($tree->find_node('AN2438.1')->branch_length, '0.28221');
ok($tree->find_node('FG05298.1')->branch_length, '0.20593');

# simple topology test - make sure these 2 are sister
ok($tree->find_node('YOR262W')->ancestor->id, 
   $tree->find_node('Smik_Contig1103.1')->ancestor->id);

# TODO 
# UPGMA tests


# test the bootstrap
my $replicates = &bootstrap_replicates($aln,10);
ok(scalar @$replicates, 10);
