# This Makefile.PL for Test-SVN-Repo was generated by
# inc::TSRMakeMaker <self>
# and Dist::Zilla::Plugin::MakeMaker::Awesome 0.20.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.006;

use ExtUtils::MakeMaker 6.30;

use File::Temp ();
use IPC::Cmd qw( can_run );
use IPC::Run qw( run );

sub svn_is_installed {

    my %path;

    # Check that the basic svn commands are available.
    for my $cmd (qw( svn svnadmin svnserve )) {
        return unless $path{$cmd} = can_run($cmd);
    }

    my $temp = File::Temp::newdir('temp.XXXX',
                                  CLEANUP => 1, EXLOCK => 0, TMPDIR => 1);

    # Check that we can create a repo
    return unless run([ $path{svnadmin}, 'create', $temp ]);

    # Check that we can spawn a server for the repo
    my ($in, $out, $err);
    return unless run([ $path{svnserve}, '-i', '-r' => $temp, '--foreground' ],
                        \$in, \$out, \$err);

    return 1;
}

if (!svn_is_installed()) {
    warn 'Subversion does not appear to be installed correctly, exiting';
    exit 0;
}



my %WriteMakefileArgs = (
  "ABSTRACT" => "Subversion repository fixtures for testing",
  "AUTHOR" => "Stephen Thirlwall <sdt\@cpan.org>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30",
    "File::Temp" => 0,
    "IPC::Cmd" => 0,
    "IPC::Run" => 0
  },
  "DISTNAME" => "Test-SVN-Repo",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "Test::SVN::Repo",
  "PREREQ_PM" => {
    "Carp" => 0,
    "Class::Accessor" => 0,
    "File::Temp" => 0,
    "IPC::Run" => 0,
    "POSIX" => 0,
    "Path::Class" => 0,
    "Scalar::Util" => 0,
    "Test::Builder::Module" => 0,
    "Try::Tiny" => 0,
    "URI::file" => 0,
    "base" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "File::Spec" => 0,
    "IO::Handle" => 0,
    "IPC::Cmd" => 0,
    "IPC::Open3" => 0,
    "Probe::Perl" => 0,
    "Test::Exception" => 0,
    "Test::More" => 0,
    "Test::NoWarnings" => 0
  },
  "VERSION" => "0.016",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "Carp" => 0,
  "Class::Accessor" => 0,
  "File::Spec" => 0,
  "File::Temp" => 0,
  "IO::Handle" => 0,
  "IPC::Cmd" => 0,
  "IPC::Open3" => 0,
  "IPC::Run" => 0,
  "POSIX" => 0,
  "Path::Class" => 0,
  "Probe::Perl" => 0,
  "Scalar::Util" => 0,
  "Test::Builder::Module" => 0,
  "Test::Exception" => 0,
  "Test::More" => 0,
  "Test::NoWarnings" => 0,
  "Try::Tiny" => 0,
  "URI::file" => 0,
  "base" => 0,
  "strict" => 0,
  "warnings" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



