use File::Temp qw/ tempdir /;
use Test::More tests => 8;
use utf8;
use strict;
use warnings;

my $dir = tempdir(CLEANUP => 1);
#my $dir = "/tmp";

#
# Test 1: load the module
#
BEGIN {
    use_ok('Graphics::Fig')
};

#
# Test 2: lineto given distance, heading
#
eval {
    my $fig = Graphics::Fig->new({ position => [ 3, 2 ], arrowMode => "forw" });
    $fig->lineto(2 * sqrt(2), 45);
    $fig->save("${dir}/lineto2.fig");
    system("diff -qb t/lineto2.fig ${dir}/lineto2.fig") == 0 || die;
};
ok($@ eq "", "test2");

#
# Test 3: lineto given multiple distance, heading pairs
#
eval {
    my $fig = Graphics::Fig->new({ position => [ 3, 2 ], arrowMode => "forw" });
    $fig->lineto(3,   30);
    $fig->lineto(2,  120);
    $fig->lineto(3, -150);
    $fig->lineto(2,  -60);
    $fig->save("${dir}/lineto3.fig");
    system("diff -qb t/lineto3.fig ${dir}/lineto3.fig") == 0 || die;
};
ok($@ eq "", "test3");

#
# Test 4: lineto given one point
#
eval {
    my $fig = Graphics::Fig->new({ position => [ 3, 2 ], arrowMode => "forw" });
    $fig->lineto([ -1, -1 ]);
    $fig->save("${dir}/lineto4.fig");
    system("diff -qb t/lineto4.fig ${dir}/lineto4.fig") == 0 || die;
};
ok($@ eq "", "test4");

#
# Test 5: lineto given multiple points (ignoring detachedLineto)
#
eval {
    my $fig = Graphics::Fig->new({ position => [ 3, 2 ], arrowMode => "forw",
    				   detachedLineto => 1 });
    $fig->lineto([[ 2, 1 ], [ 0, 4 ], [ 4, 0 ]]);
    $fig->save("${dir}/lineto5.fig");
    system("diff -qb t/lineto5.fig ${dir}/lineto5.fig") == 0 || die;
};
ok($@ eq "", "test5");

#
# Test 6: multiple lineto calls
#
eval {
    my $fig = Graphics::Fig->new({ position => [ 1, 1 ], arrowMode => "forw" });
    $fig->lineto([ 1, 3 ]);
    $fig->lineto([ 3, 5 ]);
    $fig->lineto([ 5, 5 ]);
    $fig->save("${dir}/lineto6.fig");
    system("diff -qb t/lineto6.fig ${dir}/lineto6.fig") == 0 || die;
};
ok($@ eq "", "test6");

#
# Test 7: multiple lineto calls, globally detached
#
eval {
    my $fig = Graphics::Fig->new({ position => [ 2, 2 ], arrowMode => "forw",
    				   detachedLineto => 1 });
    $fig->lineto([[ 2, 3 ], [ 3, 3 ]]);
    $fig->lineto([[ 3, 2 ], [ 4, 2 ]]);
    $fig->lineto([[ 4, 1 ], [ 3, 1 ]]);
    $fig->save("${dir}/lineto7.fig");
    system("diff -qb t/lineto7.fig ${dir}/lineto7.fig") == 0 || die;
};
ok($@ eq "", "test7");

#
# Test 8: multiple lineto calls, locally detached
#
eval {
    my $fig = Graphics::Fig->new({ arrowMode => "forw" });
    $fig->lineto(1,  135);
    $fig->lineto(2,   45);
    $fig->lineto(3,  -45, { new => 1 });
    $fig->lineto(4, -135);
    $fig->lineto(5,  135);
    $fig->lineto(6,   45);
    $fig->lineto(7,  -45, { new => 1 });
    $fig->lineto(8, -135);
    $fig->save("${dir}/lineto8.fig");
    system("diff -qb t/lineto8.fig ${dir}/lineto8.fig") == 0 || die;
};
ok($@ eq "", "test8");


exit(0);
