use File::Temp qw/ tempdir /;
use Test::More tests => 7;
use utf8;
use strict;
use warnings;

my $dir = tempdir(CLEANUP => 1);
#my $dir = "/tmp";

#
# Test 1: load the module
#
BEGIN {
    use_ok('Graphics::Fig')
};

#
# Test 2: arcto given distance and heading
#
eval {
    my $fig = Graphics::Fig->new({ position => [ 2, 1 ], arrowMode => "forw" });
    $fig->arcto(2 * sqrt(2), 135);
    $fig->arcto({ distance => 2 * sqrt(2), heading => 225 });
    $fig->save("${dir}/arcto2.fig");
    system("diff -qb t/arcto2.fig ${dir}/arcto2.fig") == 0 || die;
};
ok($@ eq "", "test2");

#
# Test 3: arcto given distance, heading and angle
#
eval {
    my $fig = Graphics::Fig->new({ position  => [ -1, 1 ],
    				   arrowMode => "forw" });
    $fig->arcto(2,    0, -270 );
    $fig->arcto({ distance => 2, heading => -180, angle => 180 });
    $fig->save("${dir}/arcto3.fig");
    system("diff -qb t/arcto3.fig ${dir}/arcto3.fig") == 0 || die;
};
ok($@ eq "", "test3");

#
# Test 4: arcto given center and direction
#
eval {
    my $fig = Graphics::Fig->new({ position => [ 1, 1 ], arrowMode => "forw" });
    $fig->arcto({ center => [ 2, 1 ], direction => "ccw" });
    $fig->arcto({ center => [ 2, 3 ], direction => "cw" });
    $fig->save("${dir}/arcto4.fig");
    system("diff -qb t/arcto4.fig ${dir}/arcto4.fig") == 0 || die;
};
ok($@ eq "", "test4");

#
# Test 5: arcto given final point (and control angle)
#
eval {
    my $fig = Graphics::Fig->new({ position => [ 4, 0 ], arrowMode => "forw" });
    $fig->arcto([  0, 3 ]);
    $fig->arcto([ -3, 1 ], { controlAngle => 30 });
    $fig->arcto({ point => [  4, 0 ] });
    $fig->save("${dir}/arcto5.fig");
    system("diff -qb t/arcto5.fig ${dir}/arcto5.fig") == 0 || die;
};
ok($@ eq "", "test5");

#
# Test 6: arcto given control-point, final-point
#
eval {
    my $fig = Graphics::Fig->new({ position => [ 0, 4 ], arrowMode => "forw" });
    $fig->arcto([[  2,  3 ], [  3, -1 ]]);
    $fig->arcto([[  2,  1 ], [ -2,  3 ]]);
    $fig->arcto({ points => [[ -2, -2 ], [  1,  1 ]] });
    $fig->save("${dir}/arcto6.fig");
    system("diff -qb t/arcto6.fig ${dir}/arcto6.fig") == 0 || die;
};
ok($@ eq "", "test6");

#
# Test 7: arcto closed and filled
#
eval {
    my $fig = Graphics::Fig->new();
    $fig->arcto({ position => [ -1, 0 ], distance => 1, heading => 0,
                  angle => 180, subtype => "closed", areaFill => "saturated",
		  color => "blue", fillColor => "yellow" });
    $fig->arcto({ distance => 1, heading => 0,
                  angle => -180, subtype => "pie-wedge", areaFill => "full",
		  color => "red", fillColor => "magenta" });
    $fig->save("${dir}/arcto7.fig");
    system("diff -qb t/arcto7.fig ${dir}/arcto7.fig") == 0 || die;
};
ok($@ eq "", "test7");


exit(0);
