package App::Bootstrap::Perl;

use strict;
use warnings;

our $VERSION = '0.01';

1;

=head1 NAME

App::Bootstrap:Perl - Bootstrap Perl inclusive CPAN from git

=head1 ABOUT

This is the corresponding namespace for L<bootstrap-perl>, a tool to
bootstrap Perl installations inclusive a CPAN environment from git.

=head1 AUTHOR

Steffen Schwigon, C<< <ss5 at renormalist.net> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-app-bootstrap-perl at
rt.cpan.org>, or through the web interface at
L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=App-Bootstrap-Perl>.  I will
be notified, and then you'll automatically be notified of progress on
your bug as I make changes.


=head1 SUPPORT

You can look for information at:

=over 4

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=App-Bootstrap-Perl>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/App-Bootstrap-Perl>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/App-Bootstrap-Perl>

=item * Search CPAN

L<http://search.cpan.org/dist/App-Bootstrap-Perl/>

=back


=head1 COPYRIGHT & LICENSE

Copyright 2011 Steffen Schwigon, all rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut
