#! /usr/local/bin/perl -w


#################################################################################
#										#
#  										#
#   UNIX Crypt v.0.1								#
#   Copyright (C) 2003-2004 - Steven Schubiger <steven@accognoscere.org>	#
#   Last changes: 14th November 2004						#
#										#
#   This program is free software; you can redistribute it and/or modify	#
#   it under the terms of the GNU General Public License as published by	#
#   the Free Software Foundation; either version 2 of the License, or		#
#   (at your option) any later version.						#
#										#
#   This program is distributed in the hope that it will be useful,		#
#   but WITHOUT ANY WARRANTY; without even the implied warranty of		#
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		#
#   GNU General Public License for more details.				#
#										#
#   You should have received a copy of the GNU General Public License		#
#   along with this program; if not, write to the Free Software			#
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA	#
#										#
#										#
#################################################################################




# Include the configuration file
require 'crypt.cfg';

# Parse the CGI environment
use CGI;

my $query = new CGI;
my $action = $query->param('action');
my $password = $query->param('password');


# Launch the main functions
unless ($action) { &print_form() }
elsif ($action eq 'encrypt_pw') { &encrypt_pw() }


# Print the HTML form page & exit
sub print_form {
    my $print_form_html = &parse_template ($crypt_template);

    $print_form_html =~ s/\$SCRIPT_URL_INVISIBLE/$script_url/;

    unless (defined( $encrypted_pw )) {
        $print_form_html =~ s/\$ENCRYPTED_PW//;
    } else {
        $print_form_html =~ s/\$ENCRYPTED_PW/$encrypted_pw/;
    }

    print "Content-type: text/html\n\n";
    print $print_form_html;
    exit (0);
}


# Encrypt the submitted password in UNIX standard (DES)
sub encrypt_pw {
    my $pattern = int( rand( 9999 ) + 10 );
    $encrypted_pw = crypt( $password, $pattern );
    
    &print_form();
}


# Parse a HTML template & return the HTML
sub parse_template {
    my $template = shift (@_);

    my $template_html;

    open (TEMPLATE, "<$template") or die "Could not open $template: $!\n";
    while (! eof(TEMPLATE) ) {
        $template_html .= <TEMPLATE>;
    }
    close (TEMPLATE) or die "Could not close $template: $!\n";

    return $template_html;
}


