

require 5;
use strict;
use Test;
BEGIN { plan tests => 39 }

#sub XML::RSS::Timing::DEBUG () {10}

use XML::RSS::Timing;
print "# I'm testing XML::RSS::Timing version $XML::RSS::Timing::VERSION\n";

ok 1;
print "# Required OK.\n";

use Time::Local;
my $E1970 = timegm(0,0,0,1,0,70);
ok 1;
print "# E1970 = $E1970 s  (", scalar(gmtime($E1970)), ")\n";

sub t ($$) {
  my $x = XML::RSS::Timing->new;
  $x->use_exceptions(0);
  my $out = $x->_iso_date_to_epoch( $_[0] );
  $out = join '', "ERR(", $x->complaints, ")" unless defined $out;
  return
    $out,
    ($_[1] =~ m/^\d+$/s) ? $_[1] + $E1970 : $_[1],
    "input date: $_[0]"
  ;
}

&ok(t '1970-01-01T00:00',          0);
&ok(t '1970-01-01T00:00+00:00',    0);
&ok(t '1970-01-01T00:00-00:00',    0);

&ok(t '1970-01-01T00:01',         60);
&ok(t '1970-01-01T00:01+00:00',   60);
&ok(t '1970-01-01T00:01-00:00',   60);

&ok(t '1970-01-01T01:00',        60*60);
&ok(t '1970-01-01T01:00+00:00',  60*60);
&ok(t '1970-01-01T01:00-00:00',  60*60);

&ok(t '1970-01-01T00:10',        10*60);
&ok(t '1970-01-01T08:10+08:00',  10*60);

&ok(t '1970-01-01T00:59',        59*60);
&ok(t '1970-01-01T08:59+08:00',  59*60);

&ok(t '1970-01-01T09:00',      9*60*60);
&ok(t '1970-01-01T10:00+01:00',9*60*60);
&ok(t '1970-01-01T08:00-01:00',9*60*60);

&ok(t '1970-01-01T09:23',      9*60*60 + 23*60);
&ok(t '1970-01-01T10:23+01:00',9*60*60 + 23*60);
&ok(t '1970-01-01T08:23-01:00',9*60*60 + 23*60);

&ok(t '1970-01-01T09:00',      9*60*60);
&ok(t '1970-01-01T10:30+01:30',9*60*60);
&ok(t '1970-01-01T07:30-01:30',9*60*60);

&ok(t '1970-01-01T09:00',      9*60*60);
&ok(t '1970-01-01T10:40+01:40',9*60*60);
&ok(t '1970-01-01T07:20-01:40',9*60*60);

&ok(t '1970-01-01T09:00',      9*60*60);
&ok(t '1970-01-01T10:20+01:20',9*60*60);
&ok(t '1970-01-01T07:40-01:20',9*60*60);

&ok(t '1973-11-29T21:33', 123456780);
&ok(t '2009-02-13T23:31', 1234567860);

# Make sure it rejects some things
&ok(t  '109-02-13T23:31', '/^ERR/');
&ok(t  'i like pie'     , '/^ERR/');
&ok(t '1109-02-13T23:31', '/^ERR/');
&ok(t '2909-02-13T23:31', '/^ERR/');
&ok(t '2009-02-13T43:31', '/^ERR/');
&ok(t '2009-02-30T03:31', '/^ERR/');

print "# OK, byebye\n";
ok 1;

