package Locale::Codes::Script;

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'get_codes' is run.
#    Generated on: Mon Mar  1 13:02:30 EST 2010

=pod

=head1 NAME

Locale::Codes::Script - script codes for the Locale::Script module

=head1 SYNOPSIS

This module contains data used by the Locale::Script module. It is
not intended to be used directly, and contains no calleable routines.

=head1 AUTHOR

See Locale::Codes for full author history.

Currently maintained by Sullivan Beck (sbeck@cpan.org).

=head1 COPYRIGHT

   Copyright (c) 1997-2001 Canon Research Centre Europe (CRE).
   Copyright (c) 2001-2010 Neil Bowers
   Copyright (c) 2010-2010 Sullivan Beck

This module is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut

use strict;
use warnings;
require 5.002;

use vars qw($VERSION);
$VERSION='3.11';

$Locale::Codes::Data{'script'}{'id'} = '0137';

$Locale::Codes::Data{'script'}{'id2names'} = {
   q(0001) => [
      q(Arabic),
      ],
   q(0002) => [
      q(Imperial Aramaic),
      ],
   q(0003) => [
      q(Armenian),
      ],
   q(0004) => [
      q(Avestan),
      ],
   q(0005) => [
      q(Balinese),
      ],
   q(0006) => [
      q(Bamum),
      ],
   q(0007) => [
      q(Batak),
      ],
   q(0008) => [
      q(Bengali),
      ],
   q(0009) => [
      q(Blissymbols),
      ],
   q(0010) => [
      q(Bopomofo),
      ],
   q(0011) => [
      q(Brahmi),
      ],
   q(0012) => [
      q(Braille),
      ],
   q(0013) => [
      q(Buginese),
      ],
   q(0014) => [
      q(Buhid),
      ],
   q(0015) => [
      q(Chakma),
      ],
   q(0016) => [
      q(Unified Canadian Aboriginal Syllabics),
      ],
   q(0017) => [
      q(Carian),
      ],
   q(0018) => [
      q(Cham),
      ],
   q(0019) => [
      q(Cherokee),
      ],
   q(0020) => [
      q(Cirth),
      ],
   q(0021) => [
      q(Coptic),
      ],
   q(0022) => [
      q(Cypriot),
      ],
   q(0023) => [
      q(Cyrillic),
      ],
   q(0024) => [
      q(Cyrillic (Old Church Slavonic variant)),
      ],
   q(0025) => [
      q(Devanagari (Nagari)),
      ],
   q(0026) => [
      q(Deseret (Mormon)),
      ],
   q(0027) => [
      q(Egyptian demotic),
      ],
   q(0028) => [
      q(Egyptian hieratic),
      ],
   q(0029) => [
      q(Egyptian hieroglyphs),
      ],
   q(0030) => [
      q(Ethiopic (Geez)),
      ],
   q(0031) => [
      q(Georgian (Mkhedruli)),
      ],
   q(0032) => [
      q(Khutsuri (Asomtavruli and Nuskhuri)),
      ],
   q(0033) => [
      q(Glagolitic),
      ],
   q(0034) => [
      q(Gothic),
      ],
   q(0035) => [
      q(Grantha),
      ],
   q(0036) => [
      q(Greek),
      ],
   q(0037) => [
      q(Gujarati),
      ],
   q(0038) => [
      q(Gurmukhi),
      ],
   q(0039) => [
      q(Hangul (Hangul, Hangeul)),
      ],
   q(0040) => [
      q(Han (Hanzi, Kanji, Hanja)),
      ],
   q(0041) => [
      q(Hanunoo (Hanunoo)),
      ],
   q(0042) => [
      q(Han (Simplified variant)),
      ],
   q(0043) => [
      q(Han (Traditional variant)),
      ],
   q(0044) => [
      q(Hebrew),
      ],
   q(0045) => [
      q(Hiragana),
      ],
   q(0046) => [
      q(Pahawh Hmong),
      ],
   q(0047) => [
      q((alias for Hiragana + Katakana)),
      ],
   q(0048) => [
      q(Old Hungarian),
      ],
   q(0049) => [
      q(Indus (Harappan)),
      ],
   q(0050) => [
      q(Old Italic (Etruscan, Oscan, etc.)),
      ],
   q(0051) => [
      q(Javanese),
      ],
   q(0052) => [
      q(Japanese (alias for Han + Hiragana + Katakana)),
      ],
   q(0053) => [
      q(Kayah Li),
      ],
   q(0054) => [
      q(Katakana),
      ],
   q(0055) => [
      q(Kharoshthi),
      ],
   q(0056) => [
      q(Khmer),
      ],
   q(0057) => [
      q(Kannada),
      ],
   q(0058) => [
      q(Korean (alias for Hangul + Han)),
      ],
   q(0059) => [
      q(Kaithi),
      ],
   q(0060) => [
      q(Tai Tham (Lanna)),
      ],
   q(0061) => [
      q(Lao),
      ],
   q(0062) => [
      q(Latin (Fraktur variant)),
      ],
   q(0063) => [
      q(Latin (Gaelic variant)),
      ],
   q(0064) => [
      q(Latin),
      ],
   q(0065) => [
      q(Lepcha (Rong)),
      ],
   q(0066) => [
      q(Limbu),
      ],
   q(0067) => [
      q(Linear A),
      ],
   q(0068) => [
      q(Linear B),
      ],
   q(0069) => [
      q(Lisu (Fraser)),
      ],
   q(0070) => [
      q(Lycian),
      ],
   q(0071) => [
      q(Lydian),
      ],
   q(0072) => [
      q(Mandaic, Mandaean),
      ],
   q(0073) => [
      q(Manichaean),
      ],
   q(0074) => [
      q(Mayan hieroglyphs),
      ],
   q(0075) => [
      q(Meroitic Cursive),
      ],
   q(0076) => [
      q(Meroitic Hieroglyphs),
      ],
   q(0077) => [
      q(Malayalam),
      ],
   q(0078) => [
      q(Moon (Moon code, Moon script, Moon type)),
      ],
   q(0079) => [
      q(Mongolian),
      ],
   q(0080) => [
      q(Meitei Mayek (Meithei, Meetei)),
      ],
   q(0081) => [
      q(Myanmar (Burmese)),
      ],
   q(0082) => [
      q(Nakhi Geba ('Na-'Khi Ggo-baw, Naxi Geba)),
      ],
   q(0083) => [
      q(N'Ko),
      ],
   q(0084) => [
      q(Ogham),
      ],
   q(0085) => [
      q(Ol Chiki (Ol Cemet, Ol, Santali)),
      ],
   q(0086) => [
      q(Old Turkic, Orkhon Runic),
      ],
   q(0087) => [
      q(Oriya),
      ],
   q(0088) => [
      q(Osmanya),
      ],
   q(0089) => [
      q(Old Permic),
      ],
   q(0090) => [
      q(Phags-pa),
      ],
   q(0091) => [
      q(Inscriptional Pahlavi),
      ],
   q(0092) => [
      q(Psalter Pahlavi),
      ],
   q(0093) => [
      q(Book Pahlavi),
      ],
   q(0094) => [
      q(Phoenician),
      ],
   q(0095) => [
      q(Miao (Pollard)),
      ],
   q(0096) => [
      q(Inscriptional Parthian),
      ],
   q(0097) => [
      q(Reserved for private use (start)),
      ],
   q(0098) => [
      q(Reserved for private use (end)),
      ],
   q(0099) => [
      q(Rejang (Redjang, Kaganga)),
      ],
   q(0100) => [
      q(Rongorongo),
      ],
   q(0101) => [
      q(Runic),
      ],
   q(0102) => [
      q(Samaritan),
      ],
   q(0103) => [
      q(Sarati),
      ],
   q(0104) => [
      q(Old South Arabian),
      ],
   q(0105) => [
      q(Saurashtra),
      ],
   q(0106) => [
      q(SignWriting),
      ],
   q(0107) => [
      q(Shavian (Shaw)),
      ],
   q(0108) => [
      q(Sinhala),
      ],
   q(0109) => [
      q(Sundanese),
      ],
   q(0110) => [
      q(Syloti Nagri),
      ],
   q(0111) => [
      q(Syriac),
      ],
   q(0112) => [
      q(Syriac (Estrangelo variant)),
      ],
   q(0113) => [
      q(Syriac (Western variant)),
      ],
   q(0114) => [
      q(Syriac (Eastern variant)),
      ],
   q(0115) => [
      q(Tagbanwa),
      ],
   q(0116) => [
      q(Tai Le),
      ],
   q(0117) => [
      q(New Tai Lue),
      ],
   q(0118) => [
      q(Tamil),
      ],
   q(0119) => [
      q(Tai Viet),
      ],
   q(0120) => [
      q(Telugu),
      ],
   q(0121) => [
      q(Tengwar),
      ],
   q(0122) => [
      q(Tifinagh (Berber)),
      ],
   q(0123) => [
      q(Tagalog (Baybayin, Alibata)),
      ],
   q(0124) => [
      q(Thaana),
      ],
   q(0125) => [
      q(Thai),
      ],
   q(0126) => [
      q(Tibetan),
      ],
   q(0127) => [
      q(Ugaritic),
      ],
   q(0128) => [
      q(Vai),
      ],
   q(0129) => [
      q(Visible Speech),
      ],
   q(0130) => [
      q(Warang Citi (Varang Kshiti)),
      ],
   q(0131) => [
      q(Old Persian),
      ],
   q(0132) => [
      q(Cuneiform, Sumero-Akkadian),
      ],
   q(0133) => [
      q(Yi),
      ],
   q(0134) => [
      q(Code for inherited script),
      ],
   q(0135) => [
      q(Mathematical notation),
      ],
   q(0136) => [
      q(Symbols),
      ],
};

$Locale::Codes::Data{'script'}{'alias2id'} = {
   q((alias for hiragana + katakana)) => [
      q(0047),
      q(0),
      ],
   q(arabic) => [
      q(0001),
      q(0),
      ],
   q(armenian) => [
      q(0003),
      q(0),
      ],
   q(avestan) => [
      q(0004),
      q(0),
      ],
   q(balinese) => [
      q(0005),
      q(0),
      ],
   q(bamum) => [
      q(0006),
      q(0),
      ],
   q(batak) => [
      q(0007),
      q(0),
      ],
   q(bengali) => [
      q(0008),
      q(0),
      ],
   q(blissymbols) => [
      q(0009),
      q(0),
      ],
   q(book pahlavi) => [
      q(0093),
      q(0),
      ],
   q(bopomofo) => [
      q(0010),
      q(0),
      ],
   q(brahmi) => [
      q(0011),
      q(0),
      ],
   q(braille) => [
      q(0012),
      q(0),
      ],
   q(buginese) => [
      q(0013),
      q(0),
      ],
   q(buhid) => [
      q(0014),
      q(0),
      ],
   q(carian) => [
      q(0017),
      q(0),
      ],
   q(chakma) => [
      q(0015),
      q(0),
      ],
   q(cham) => [
      q(0018),
      q(0),
      ],
   q(cherokee) => [
      q(0019),
      q(0),
      ],
   q(cirth) => [
      q(0020),
      q(0),
      ],
   q(code for inherited script) => [
      q(0134),
      q(0),
      ],
   q(coptic) => [
      q(0021),
      q(0),
      ],
   q(cuneiform, sumero-akkadian) => [
      q(0132),
      q(0),
      ],
   q(cypriot) => [
      q(0022),
      q(0),
      ],
   q(cyrillic) => [
      q(0023),
      q(0),
      ],
   q(cyrillic (old church slavonic variant)) => [
      q(0024),
      q(0),
      ],
   q(deseret (mormon)) => [
      q(0026),
      q(0),
      ],
   q(devanagari (nagari)) => [
      q(0025),
      q(0),
      ],
   q(egyptian demotic) => [
      q(0027),
      q(0),
      ],
   q(egyptian hieratic) => [
      q(0028),
      q(0),
      ],
   q(egyptian hieroglyphs) => [
      q(0029),
      q(0),
      ],
   q(ethiopic (geez)) => [
      q(0030),
      q(0),
      ],
   q(georgian (mkhedruli)) => [
      q(0031),
      q(0),
      ],
   q(glagolitic) => [
      q(0033),
      q(0),
      ],
   q(gothic) => [
      q(0034),
      q(0),
      ],
   q(grantha) => [
      q(0035),
      q(0),
      ],
   q(greek) => [
      q(0036),
      q(0),
      ],
   q(gujarati) => [
      q(0037),
      q(0),
      ],
   q(gurmukhi) => [
      q(0038),
      q(0),
      ],
   q(han (hanzi, kanji, hanja)) => [
      q(0040),
      q(0),
      ],
   q(han (simplified variant)) => [
      q(0042),
      q(0),
      ],
   q(han (traditional variant)) => [
      q(0043),
      q(0),
      ],
   q(hangul (hangul, hangeul)) => [
      q(0039),
      q(0),
      ],
   q(hanunoo (hanunoo)) => [
      q(0041),
      q(0),
      ],
   q(hebrew) => [
      q(0044),
      q(0),
      ],
   q(hiragana) => [
      q(0045),
      q(0),
      ],
   q(imperial aramaic) => [
      q(0002),
      q(0),
      ],
   q(indus (harappan)) => [
      q(0049),
      q(0),
      ],
   q(inscriptional pahlavi) => [
      q(0091),
      q(0),
      ],
   q(inscriptional parthian) => [
      q(0096),
      q(0),
      ],
   q(japanese (alias for han + hiragana + katakana)) => [
      q(0052),
      q(0),
      ],
   q(javanese) => [
      q(0051),
      q(0),
      ],
   q(kaithi) => [
      q(0059),
      q(0),
      ],
   q(kannada) => [
      q(0057),
      q(0),
      ],
   q(katakana) => [
      q(0054),
      q(0),
      ],
   q(kayah li) => [
      q(0053),
      q(0),
      ],
   q(kharoshthi) => [
      q(0055),
      q(0),
      ],
   q(khmer) => [
      q(0056),
      q(0),
      ],
   q(khutsuri (asomtavruli and nuskhuri)) => [
      q(0032),
      q(0),
      ],
   q(korean (alias for hangul + han)) => [
      q(0058),
      q(0),
      ],
   q(lao) => [
      q(0061),
      q(0),
      ],
   q(latin) => [
      q(0064),
      q(0),
      ],
   q(latin (fraktur variant)) => [
      q(0062),
      q(0),
      ],
   q(latin (gaelic variant)) => [
      q(0063),
      q(0),
      ],
   q(lepcha (rong)) => [
      q(0065),
      q(0),
      ],
   q(limbu) => [
      q(0066),
      q(0),
      ],
   q(linear a) => [
      q(0067),
      q(0),
      ],
   q(linear b) => [
      q(0068),
      q(0),
      ],
   q(lisu (fraser)) => [
      q(0069),
      q(0),
      ],
   q(lycian) => [
      q(0070),
      q(0),
      ],
   q(lydian) => [
      q(0071),
      q(0),
      ],
   q(malayalam) => [
      q(0077),
      q(0),
      ],
   q(mandaic, mandaean) => [
      q(0072),
      q(0),
      ],
   q(manichaean) => [
      q(0073),
      q(0),
      ],
   q(mathematical notation) => [
      q(0135),
      q(0),
      ],
   q(mayan hieroglyphs) => [
      q(0074),
      q(0),
      ],
   q(meitei mayek (meithei, meetei)) => [
      q(0080),
      q(0),
      ],
   q(meroitic cursive) => [
      q(0075),
      q(0),
      ],
   q(meroitic hieroglyphs) => [
      q(0076),
      q(0),
      ],
   q(miao (pollard)) => [
      q(0095),
      q(0),
      ],
   q(mongolian) => [
      q(0079),
      q(0),
      ],
   q(moon (moon code, moon script, moon type)) => [
      q(0078),
      q(0),
      ],
   q(myanmar (burmese)) => [
      q(0081),
      q(0),
      ],
   q(n'ko) => [
      q(0083),
      q(0),
      ],
   q(nakhi geba ('na-'khi ggo-baw, naxi geba)) => [
      q(0082),
      q(0),
      ],
   q(new tai lue) => [
      q(0117),
      q(0),
      ],
   q(ogham) => [
      q(0084),
      q(0),
      ],
   q(ol chiki (ol cemet, ol, santali)) => [
      q(0085),
      q(0),
      ],
   q(old hungarian) => [
      q(0048),
      q(0),
      ],
   q(old italic (etruscan, oscan, etc.)) => [
      q(0050),
      q(0),
      ],
   q(old permic) => [
      q(0089),
      q(0),
      ],
   q(old persian) => [
      q(0131),
      q(0),
      ],
   q(old south arabian) => [
      q(0104),
      q(0),
      ],
   q(old turkic, orkhon runic) => [
      q(0086),
      q(0),
      ],
   q(oriya) => [
      q(0087),
      q(0),
      ],
   q(osmanya) => [
      q(0088),
      q(0),
      ],
   q(pahawh hmong) => [
      q(0046),
      q(0),
      ],
   q(phags-pa) => [
      q(0090),
      q(0),
      ],
   q(phoenician) => [
      q(0094),
      q(0),
      ],
   q(psalter pahlavi) => [
      q(0092),
      q(0),
      ],
   q(rejang (redjang, kaganga)) => [
      q(0099),
      q(0),
      ],
   q(reserved for private use (end)) => [
      q(0098),
      q(0),
      ],
   q(reserved for private use (start)) => [
      q(0097),
      q(0),
      ],
   q(rongorongo) => [
      q(0100),
      q(0),
      ],
   q(runic) => [
      q(0101),
      q(0),
      ],
   q(samaritan) => [
      q(0102),
      q(0),
      ],
   q(sarati) => [
      q(0103),
      q(0),
      ],
   q(saurashtra) => [
      q(0105),
      q(0),
      ],
   q(shavian (shaw)) => [
      q(0107),
      q(0),
      ],
   q(signwriting) => [
      q(0106),
      q(0),
      ],
   q(sinhala) => [
      q(0108),
      q(0),
      ],
   q(sundanese) => [
      q(0109),
      q(0),
      ],
   q(syloti nagri) => [
      q(0110),
      q(0),
      ],
   q(symbols) => [
      q(0136),
      q(0),
      ],
   q(syriac) => [
      q(0111),
      q(0),
      ],
   q(syriac (eastern variant)) => [
      q(0114),
      q(0),
      ],
   q(syriac (estrangelo variant)) => [
      q(0112),
      q(0),
      ],
   q(syriac (western variant)) => [
      q(0113),
      q(0),
      ],
   q(tagalog (baybayin, alibata)) => [
      q(0123),
      q(0),
      ],
   q(tagbanwa) => [
      q(0115),
      q(0),
      ],
   q(tai le) => [
      q(0116),
      q(0),
      ],
   q(tai tham (lanna)) => [
      q(0060),
      q(0),
      ],
   q(tai viet) => [
      q(0119),
      q(0),
      ],
   q(tamil) => [
      q(0118),
      q(0),
      ],
   q(telugu) => [
      q(0120),
      q(0),
      ],
   q(tengwar) => [
      q(0121),
      q(0),
      ],
   q(thaana) => [
      q(0124),
      q(0),
      ],
   q(thai) => [
      q(0125),
      q(0),
      ],
   q(tibetan) => [
      q(0126),
      q(0),
      ],
   q(tifinagh (berber)) => [
      q(0122),
      q(0),
      ],
   q(ugaritic) => [
      q(0127),
      q(0),
      ],
   q(unified canadian aboriginal syllabics) => [
      q(0016),
      q(0),
      ],
   q(vai) => [
      q(0128),
      q(0),
      ],
   q(visible speech) => [
      q(0129),
      q(0),
      ],
   q(warang citi (varang kshiti)) => [
      q(0130),
      q(0),
      ],
   q(yi) => [
      q(0133),
      q(0),
      ],
};

$Locale::Codes::Data{'script'}{'code2id'} = {
   q(alpha) => {
      q(Arab) => [
         q(0001),
         q(0),
         ],
      q(Armi) => [
         q(0002),
         q(0),
         ],
      q(Armn) => [
         q(0003),
         q(0),
         ],
      q(Avst) => [
         q(0004),
         q(0),
         ],
      q(Bali) => [
         q(0005),
         q(0),
         ],
      q(Bamu) => [
         q(0006),
         q(0),
         ],
      q(Batk) => [
         q(0007),
         q(0),
         ],
      q(Beng) => [
         q(0008),
         q(0),
         ],
      q(Blis) => [
         q(0009),
         q(0),
         ],
      q(Bopo) => [
         q(0010),
         q(0),
         ],
      q(Brah) => [
         q(0011),
         q(0),
         ],
      q(Brai) => [
         q(0012),
         q(0),
         ],
      q(Bugi) => [
         q(0013),
         q(0),
         ],
      q(Buhd) => [
         q(0014),
         q(0),
         ],
      q(Cakm) => [
         q(0015),
         q(0),
         ],
      q(Cans) => [
         q(0016),
         q(0),
         ],
      q(Cari) => [
         q(0017),
         q(0),
         ],
      q(Cham) => [
         q(0018),
         q(0),
         ],
      q(Cher) => [
         q(0019),
         q(0),
         ],
      q(Cirt) => [
         q(0020),
         q(0),
         ],
      q(Copt) => [
         q(0021),
         q(0),
         ],
      q(Cprt) => [
         q(0022),
         q(0),
         ],
      q(Cyrl) => [
         q(0023),
         q(0),
         ],
      q(Cyrs) => [
         q(0024),
         q(0),
         ],
      q(Deva) => [
         q(0025),
         q(0),
         ],
      q(Dsrt) => [
         q(0026),
         q(0),
         ],
      q(Egyd) => [
         q(0027),
         q(0),
         ],
      q(Egyh) => [
         q(0028),
         q(0),
         ],
      q(Egyp) => [
         q(0029),
         q(0),
         ],
      q(Ethi) => [
         q(0030),
         q(0),
         ],
      q(Geok) => [
         q(0032),
         q(0),
         ],
      q(Geor) => [
         q(0031),
         q(0),
         ],
      q(Glag) => [
         q(0033),
         q(0),
         ],
      q(Goth) => [
         q(0034),
         q(0),
         ],
      q(Gran) => [
         q(0035),
         q(0),
         ],
      q(Grek) => [
         q(0036),
         q(0),
         ],
      q(Gujr) => [
         q(0037),
         q(0),
         ],
      q(Guru) => [
         q(0038),
         q(0),
         ],
      q(Hang) => [
         q(0039),
         q(0),
         ],
      q(Hani) => [
         q(0040),
         q(0),
         ],
      q(Hano) => [
         q(0041),
         q(0),
         ],
      q(Hans) => [
         q(0042),
         q(0),
         ],
      q(Hant) => [
         q(0043),
         q(0),
         ],
      q(Hebr) => [
         q(0044),
         q(0),
         ],
      q(Hira) => [
         q(0045),
         q(0),
         ],
      q(Hmng) => [
         q(0046),
         q(0),
         ],
      q(Hrkt) => [
         q(0047),
         q(0),
         ],
      q(Hung) => [
         q(0048),
         q(0),
         ],
      q(Inds) => [
         q(0049),
         q(0),
         ],
      q(Ital) => [
         q(0050),
         q(0),
         ],
      q(Java) => [
         q(0051),
         q(0),
         ],
      q(Jpan) => [
         q(0052),
         q(0),
         ],
      q(Kali) => [
         q(0053),
         q(0),
         ],
      q(Kana) => [
         q(0054),
         q(0),
         ],
      q(Khar) => [
         q(0055),
         q(0),
         ],
      q(Khmr) => [
         q(0056),
         q(0),
         ],
      q(Knda) => [
         q(0057),
         q(0),
         ],
      q(Kore) => [
         q(0058),
         q(0),
         ],
      q(Kthi) => [
         q(0059),
         q(0),
         ],
      q(Lana) => [
         q(0060),
         q(0),
         ],
      q(Laoo) => [
         q(0061),
         q(0),
         ],
      q(Latf) => [
         q(0062),
         q(0),
         ],
      q(Latg) => [
         q(0063),
         q(0),
         ],
      q(Latn) => [
         q(0064),
         q(0),
         ],
      q(Lepc) => [
         q(0065),
         q(0),
         ],
      q(Limb) => [
         q(0066),
         q(0),
         ],
      q(Lina) => [
         q(0067),
         q(0),
         ],
      q(Linb) => [
         q(0068),
         q(0),
         ],
      q(Lisu) => [
         q(0069),
         q(0),
         ],
      q(Lyci) => [
         q(0070),
         q(0),
         ],
      q(Lydi) => [
         q(0071),
         q(0),
         ],
      q(Mand) => [
         q(0072),
         q(0),
         ],
      q(Mani) => [
         q(0073),
         q(0),
         ],
      q(Maya) => [
         q(0074),
         q(0),
         ],
      q(Merc) => [
         q(0075),
         q(0),
         ],
      q(Mero) => [
         q(0076),
         q(0),
         ],
      q(Mlym) => [
         q(0077),
         q(0),
         ],
      q(Mong) => [
         q(0079),
         q(0),
         ],
      q(Moon) => [
         q(0078),
         q(0),
         ],
      q(Mtei) => [
         q(0080),
         q(0),
         ],
      q(Mymr) => [
         q(0081),
         q(0),
         ],
      q(Nkgb) => [
         q(0082),
         q(0),
         ],
      q(Nkoo) => [
         q(0083),
         q(0),
         ],
      q(Ogam) => [
         q(0084),
         q(0),
         ],
      q(Olck) => [
         q(0085),
         q(0),
         ],
      q(Orkh) => [
         q(0086),
         q(0),
         ],
      q(Orya) => [
         q(0087),
         q(0),
         ],
      q(Osma) => [
         q(0088),
         q(0),
         ],
      q(Perm) => [
         q(0089),
         q(0),
         ],
      q(Phag) => [
         q(0090),
         q(0),
         ],
      q(Phli) => [
         q(0091),
         q(0),
         ],
      q(Phlp) => [
         q(0092),
         q(0),
         ],
      q(Phlv) => [
         q(0093),
         q(0),
         ],
      q(Phnx) => [
         q(0094),
         q(0),
         ],
      q(Plrd) => [
         q(0095),
         q(0),
         ],
      q(Prti) => [
         q(0096),
         q(0),
         ],
      q(Qaaa) => [
         q(0097),
         q(0),
         ],
      q(Qabx) => [
         q(0098),
         q(0),
         ],
      q(Rjng) => [
         q(0099),
         q(0),
         ],
      q(Roro) => [
         q(0100),
         q(0),
         ],
      q(Runr) => [
         q(0101),
         q(0),
         ],
      q(Samr) => [
         q(0102),
         q(0),
         ],
      q(Sara) => [
         q(0103),
         q(0),
         ],
      q(Sarb) => [
         q(0104),
         q(0),
         ],
      q(Saur) => [
         q(0105),
         q(0),
         ],
      q(Sgnw) => [
         q(0106),
         q(0),
         ],
      q(Shaw) => [
         q(0107),
         q(0),
         ],
      q(Sinh) => [
         q(0108),
         q(0),
         ],
      q(Sund) => [
         q(0109),
         q(0),
         ],
      q(Sylo) => [
         q(0110),
         q(0),
         ],
      q(Syrc) => [
         q(0111),
         q(0),
         ],
      q(Syre) => [
         q(0112),
         q(0),
         ],
      q(Syrj) => [
         q(0113),
         q(0),
         ],
      q(Syrn) => [
         q(0114),
         q(0),
         ],
      q(Tagb) => [
         q(0115),
         q(0),
         ],
      q(Tale) => [
         q(0116),
         q(0),
         ],
      q(Talu) => [
         q(0117),
         q(0),
         ],
      q(Taml) => [
         q(0118),
         q(0),
         ],
      q(Tavt) => [
         q(0119),
         q(0),
         ],
      q(Telu) => [
         q(0120),
         q(0),
         ],
      q(Teng) => [
         q(0121),
         q(0),
         ],
      q(Tfng) => [
         q(0122),
         q(0),
         ],
      q(Tglg) => [
         q(0123),
         q(0),
         ],
      q(Thaa) => [
         q(0124),
         q(0),
         ],
      q(Thai) => [
         q(0125),
         q(0),
         ],
      q(Tibt) => [
         q(0126),
         q(0),
         ],
      q(Ugar) => [
         q(0127),
         q(0),
         ],
      q(Vaii) => [
         q(0128),
         q(0),
         ],
      q(Visp) => [
         q(0129),
         q(0),
         ],
      q(Wara) => [
         q(0130),
         q(0),
         ],
      q(Xpeo) => [
         q(0131),
         q(0),
         ],
      q(Xsux) => [
         q(0132),
         q(0),
         ],
      q(Yiii) => [
         q(0133),
         q(0),
         ],
      q(Zinh) => [
         q(0134),
         q(0),
         ],
      q(Zmth) => [
         q(0135),
         q(0),
         ],
      q(Zsym) => [
         q(0136),
         q(0),
         ],
      },
   q(num) => {
      q(020) => [
         q(0132),
         q(0),
         ],
      q(030) => [
         q(0131),
         q(0),
         ],
      q(040) => [
         q(0127),
         q(0),
         ],
      q(050) => [
         q(0029),
         q(0),
         ],
      q(060) => [
         q(0028),
         q(0),
         ],
      q(070) => [
         q(0027),
         q(0),
         ],
      q(090) => [
         q(0074),
         q(0),
         ],
      q(095) => [
         q(0106),
         q(0),
         ],
      q(100) => [
         q(0076),
         q(0),
         ],
      q(101) => [
         q(0075),
         q(0),
         ],
      q(105) => [
         q(0104),
         q(0),
         ],
      q(115) => [
         q(0094),
         q(0),
         ],
      q(116) => [
         q(0071),
         q(0),
         ],
      q(120) => [
         q(0122),
         q(0),
         ],
      q(123) => [
         q(0102),
         q(0),
         ],
      q(124) => [
         q(0002),
         q(0),
         ],
      q(125) => [
         q(0044),
         q(0),
         ],
      q(130) => [
         q(0096),
         q(0),
         ],
      q(131) => [
         q(0091),
         q(0),
         ],
      q(132) => [
         q(0092),
         q(0),
         ],
      q(133) => [
         q(0093),
         q(0),
         ],
      q(134) => [
         q(0004),
         q(0),
         ],
      q(135) => [
         q(0111),
         q(0),
         ],
      q(136) => [
         q(0114),
         q(0),
         ],
      q(137) => [
         q(0113),
         q(0),
         ],
      q(138) => [
         q(0112),
         q(0),
         ],
      q(139) => [
         q(0073),
         q(0),
         ],
      q(140) => [
         q(0072),
         q(0),
         ],
      q(145) => [
         q(0079),
         q(0),
         ],
      q(160) => [
         q(0001),
         q(0),
         ],
      q(165) => [
         q(0083),
         q(0),
         ],
      q(170) => [
         q(0124),
         q(0),
         ],
      q(175) => [
         q(0086),
         q(0),
         ],
      q(176) => [
         q(0048),
         q(0),
         ],
      q(200) => [
         q(0036),
         q(0),
         ],
      q(201) => [
         q(0017),
         q(0),
         ],
      q(202) => [
         q(0070),
         q(0),
         ],
      q(204) => [
         q(0021),
         q(0),
         ],
      q(206) => [
         q(0034),
         q(0),
         ],
      q(210) => [
         q(0050),
         q(0),
         ],
      q(211) => [
         q(0101),
         q(0),
         ],
      q(212) => [
         q(0084),
         q(0),
         ],
      q(215) => [
         q(0064),
         q(0),
         ],
      q(216) => [
         q(0063),
         q(0),
         ],
      q(217) => [
         q(0062),
         q(0),
         ],
      q(218) => [
         q(0078),
         q(0),
         ],
      q(220) => [
         q(0023),
         q(0),
         ],
      q(221) => [
         q(0024),
         q(0),
         ],
      q(225) => [
         q(0033),
         q(0),
         ],
      q(227) => [
         q(0089),
         q(0),
         ],
      q(230) => [
         q(0003),
         q(0),
         ],
      q(240) => [
         q(0031),
         q(0),
         ],
      q(241) => [
         q(0032),
         q(0),
         ],
      q(250) => [
         q(0026),
         q(0),
         ],
      q(260) => [
         q(0088),
         q(0),
         ],
      q(261) => [
         q(0085),
         q(0),
         ],
      q(262) => [
         q(0130),
         q(0),
         ],
      q(280) => [
         q(0129),
         q(0),
         ],
      q(281) => [
         q(0107),
         q(0),
         ],
      q(282) => [
         q(0095),
         q(0),
         ],
      q(285) => [
         q(0010),
         q(0),
         ],
      q(286) => [
         q(0039),
         q(0),
         ],
      q(287) => [
         q(0058),
         q(0),
         ],
      q(290) => [
         q(0121),
         q(0),
         ],
      q(291) => [
         q(0020),
         q(0),
         ],
      q(292) => [
         q(0103),
         q(0),
         ],
      q(300) => [
         q(0011),
         q(0),
         ],
      q(305) => [
         q(0055),
         q(0),
         ],
      q(310) => [
         q(0038),
         q(0),
         ],
      q(315) => [
         q(0025),
         q(0),
         ],
      q(316) => [
         q(0110),
         q(0),
         ],
      q(317) => [
         q(0059),
         q(0),
         ],
      q(320) => [
         q(0037),
         q(0),
         ],
      q(325) => [
         q(0008),
         q(0),
         ],
      q(327) => [
         q(0087),
         q(0),
         ],
      q(330) => [
         q(0126),
         q(0),
         ],
      q(331) => [
         q(0090),
         q(0),
         ],
      q(335) => [
         q(0065),
         q(0),
         ],
      q(336) => [
         q(0066),
         q(0),
         ],
      q(337) => [
         q(0080),
         q(0),
         ],
      q(340) => [
         q(0120),
         q(0),
         ],
      q(343) => [
         q(0035),
         q(0),
         ],
      q(344) => [
         q(0105),
         q(0),
         ],
      q(345) => [
         q(0057),
         q(0),
         ],
      q(346) => [
         q(0118),
         q(0),
         ],
      q(347) => [
         q(0077),
         q(0),
         ],
      q(348) => [
         q(0108),
         q(0),
         ],
      q(349) => [
         q(0015),
         q(0),
         ],
      q(350) => [
         q(0081),
         q(0),
         ],
      q(351) => [
         q(0060),
         q(0),
         ],
      q(352) => [
         q(0125),
         q(0),
         ],
      q(353) => [
         q(0116),
         q(0),
         ],
      q(354) => [
         q(0117),
         q(0),
         ],
      q(355) => [
         q(0056),
         q(0),
         ],
      q(356) => [
         q(0061),
         q(0),
         ],
      q(357) => [
         q(0053),
         q(0),
         ],
      q(358) => [
         q(0018),
         q(0),
         ],
      q(359) => [
         q(0119),
         q(0),
         ],
      q(360) => [
         q(0005),
         q(0),
         ],
      q(361) => [
         q(0051),
         q(0),
         ],
      q(362) => [
         q(0109),
         q(0),
         ],
      q(363) => [
         q(0099),
         q(0),
         ],
      q(365) => [
         q(0007),
         q(0),
         ],
      q(367) => [
         q(0013),
         q(0),
         ],
      q(370) => [
         q(0123),
         q(0),
         ],
      q(371) => [
         q(0041),
         q(0),
         ],
      q(372) => [
         q(0014),
         q(0),
         ],
      q(373) => [
         q(0115),
         q(0),
         ],
      q(399) => [
         q(0069),
         q(0),
         ],
      q(400) => [
         q(0067),
         q(0),
         ],
      q(401) => [
         q(0068),
         q(0),
         ],
      q(403) => [
         q(0022),
         q(0),
         ],
      q(410) => [
         q(0045),
         q(0),
         ],
      q(411) => [
         q(0054),
         q(0),
         ],
      q(412) => [
         q(0047),
         q(0),
         ],
      q(413) => [
         q(0052),
         q(0),
         ],
      q(420) => [
         q(0082),
         q(0),
         ],
      q(430) => [
         q(0030),
         q(0),
         ],
      q(435) => [
         q(0006),
         q(0),
         ],
      q(440) => [
         q(0016),
         q(0),
         ],
      q(445) => [
         q(0019),
         q(0),
         ],
      q(450) => [
         q(0046),
         q(0),
         ],
      q(460) => [
         q(0133),
         q(0),
         ],
      q(470) => [
         q(0128),
         q(0),
         ],
      q(500) => [
         q(0040),
         q(0),
         ],
      q(501) => [
         q(0042),
         q(0),
         ],
      q(502) => [
         q(0043),
         q(0),
         ],
      q(550) => [
         q(0009),
         q(0),
         ],
      q(570) => [
         q(0012),
         q(0),
         ],
      q(610) => [
         q(0049),
         q(0),
         ],
      q(620) => [
         q(0100),
         q(0),
         ],
      q(900) => [
         q(0097),
         q(0),
         ],
      q(949) => [
         q(0098),
         q(0),
         ],
      q(994) => [
         q(0134),
         q(0),
         ],
      q(995) => [
         q(0135),
         q(0),
         ],
      q(996) => [
         q(0136),
         q(0),
         ],
      },
};

$Locale::Codes::Data{'script'}{'id2code'} = {
   q(alpha) => {
      q(0001) => q(Arab),
      q(0002) => q(Armi),
      q(0003) => q(Armn),
      q(0004) => q(Avst),
      q(0005) => q(Bali),
      q(0006) => q(Bamu),
      q(0007) => q(Batk),
      q(0008) => q(Beng),
      q(0009) => q(Blis),
      q(0010) => q(Bopo),
      q(0011) => q(Brah),
      q(0012) => q(Brai),
      q(0013) => q(Bugi),
      q(0014) => q(Buhd),
      q(0015) => q(Cakm),
      q(0016) => q(Cans),
      q(0017) => q(Cari),
      q(0018) => q(Cham),
      q(0019) => q(Cher),
      q(0020) => q(Cirt),
      q(0021) => q(Copt),
      q(0022) => q(Cprt),
      q(0023) => q(Cyrl),
      q(0024) => q(Cyrs),
      q(0025) => q(Deva),
      q(0026) => q(Dsrt),
      q(0027) => q(Egyd),
      q(0028) => q(Egyh),
      q(0029) => q(Egyp),
      q(0030) => q(Ethi),
      q(0031) => q(Geor),
      q(0032) => q(Geok),
      q(0033) => q(Glag),
      q(0034) => q(Goth),
      q(0035) => q(Gran),
      q(0036) => q(Grek),
      q(0037) => q(Gujr),
      q(0038) => q(Guru),
      q(0039) => q(Hang),
      q(0040) => q(Hani),
      q(0041) => q(Hano),
      q(0042) => q(Hans),
      q(0043) => q(Hant),
      q(0044) => q(Hebr),
      q(0045) => q(Hira),
      q(0046) => q(Hmng),
      q(0047) => q(Hrkt),
      q(0048) => q(Hung),
      q(0049) => q(Inds),
      q(0050) => q(Ital),
      q(0051) => q(Java),
      q(0052) => q(Jpan),
      q(0053) => q(Kali),
      q(0054) => q(Kana),
      q(0055) => q(Khar),
      q(0056) => q(Khmr),
      q(0057) => q(Knda),
      q(0058) => q(Kore),
      q(0059) => q(Kthi),
      q(0060) => q(Lana),
      q(0061) => q(Laoo),
      q(0062) => q(Latf),
      q(0063) => q(Latg),
      q(0064) => q(Latn),
      q(0065) => q(Lepc),
      q(0066) => q(Limb),
      q(0067) => q(Lina),
      q(0068) => q(Linb),
      q(0069) => q(Lisu),
      q(0070) => q(Lyci),
      q(0071) => q(Lydi),
      q(0072) => q(Mand),
      q(0073) => q(Mani),
      q(0074) => q(Maya),
      q(0075) => q(Merc),
      q(0076) => q(Mero),
      q(0077) => q(Mlym),
      q(0078) => q(Moon),
      q(0079) => q(Mong),
      q(0080) => q(Mtei),
      q(0081) => q(Mymr),
      q(0082) => q(Nkgb),
      q(0083) => q(Nkoo),
      q(0084) => q(Ogam),
      q(0085) => q(Olck),
      q(0086) => q(Orkh),
      q(0087) => q(Orya),
      q(0088) => q(Osma),
      q(0089) => q(Perm),
      q(0090) => q(Phag),
      q(0091) => q(Phli),
      q(0092) => q(Phlp),
      q(0093) => q(Phlv),
      q(0094) => q(Phnx),
      q(0095) => q(Plrd),
      q(0096) => q(Prti),
      q(0097) => q(Qaaa),
      q(0098) => q(Qabx),
      q(0099) => q(Rjng),
      q(0100) => q(Roro),
      q(0101) => q(Runr),
      q(0102) => q(Samr),
      q(0103) => q(Sara),
      q(0104) => q(Sarb),
      q(0105) => q(Saur),
      q(0106) => q(Sgnw),
      q(0107) => q(Shaw),
      q(0108) => q(Sinh),
      q(0109) => q(Sund),
      q(0110) => q(Sylo),
      q(0111) => q(Syrc),
      q(0112) => q(Syre),
      q(0113) => q(Syrj),
      q(0114) => q(Syrn),
      q(0115) => q(Tagb),
      q(0116) => q(Tale),
      q(0117) => q(Talu),
      q(0118) => q(Taml),
      q(0119) => q(Tavt),
      q(0120) => q(Telu),
      q(0121) => q(Teng),
      q(0122) => q(Tfng),
      q(0123) => q(Tglg),
      q(0124) => q(Thaa),
      q(0125) => q(Thai),
      q(0126) => q(Tibt),
      q(0127) => q(Ugar),
      q(0128) => q(Vaii),
      q(0129) => q(Visp),
      q(0130) => q(Wara),
      q(0131) => q(Xpeo),
      q(0132) => q(Xsux),
      q(0133) => q(Yiii),
      q(0134) => q(Zinh),
      q(0135) => q(Zmth),
      q(0136) => q(Zsym),
      },
   q(num) => {
      q(0001) => q(160),
      q(0002) => q(124),
      q(0003) => q(230),
      q(0004) => q(134),
      q(0005) => q(360),
      q(0006) => q(435),
      q(0007) => q(365),
      q(0008) => q(325),
      q(0009) => q(550),
      q(0010) => q(285),
      q(0011) => q(300),
      q(0012) => q(570),
      q(0013) => q(367),
      q(0014) => q(372),
      q(0015) => q(349),
      q(0016) => q(440),
      q(0017) => q(201),
      q(0018) => q(358),
      q(0019) => q(445),
      q(0020) => q(291),
      q(0021) => q(204),
      q(0022) => q(403),
      q(0023) => q(220),
      q(0024) => q(221),
      q(0025) => q(315),
      q(0026) => q(250),
      q(0027) => q(070),
      q(0028) => q(060),
      q(0029) => q(050),
      q(0030) => q(430),
      q(0031) => q(240),
      q(0032) => q(241),
      q(0033) => q(225),
      q(0034) => q(206),
      q(0035) => q(343),
      q(0036) => q(200),
      q(0037) => q(320),
      q(0038) => q(310),
      q(0039) => q(286),
      q(0040) => q(500),
      q(0041) => q(371),
      q(0042) => q(501),
      q(0043) => q(502),
      q(0044) => q(125),
      q(0045) => q(410),
      q(0046) => q(450),
      q(0047) => q(412),
      q(0048) => q(176),
      q(0049) => q(610),
      q(0050) => q(210),
      q(0051) => q(361),
      q(0052) => q(413),
      q(0053) => q(357),
      q(0054) => q(411),
      q(0055) => q(305),
      q(0056) => q(355),
      q(0057) => q(345),
      q(0058) => q(287),
      q(0059) => q(317),
      q(0060) => q(351),
      q(0061) => q(356),
      q(0062) => q(217),
      q(0063) => q(216),
      q(0064) => q(215),
      q(0065) => q(335),
      q(0066) => q(336),
      q(0067) => q(400),
      q(0068) => q(401),
      q(0069) => q(399),
      q(0070) => q(202),
      q(0071) => q(116),
      q(0072) => q(140),
      q(0073) => q(139),
      q(0074) => q(090),
      q(0075) => q(101),
      q(0076) => q(100),
      q(0077) => q(347),
      q(0078) => q(218),
      q(0079) => q(145),
      q(0080) => q(337),
      q(0081) => q(350),
      q(0082) => q(420),
      q(0083) => q(165),
      q(0084) => q(212),
      q(0085) => q(261),
      q(0086) => q(175),
      q(0087) => q(327),
      q(0088) => q(260),
      q(0089) => q(227),
      q(0090) => q(331),
      q(0091) => q(131),
      q(0092) => q(132),
      q(0093) => q(133),
      q(0094) => q(115),
      q(0095) => q(282),
      q(0096) => q(130),
      q(0097) => q(900),
      q(0098) => q(949),
      q(0099) => q(363),
      q(0100) => q(620),
      q(0101) => q(211),
      q(0102) => q(123),
      q(0103) => q(292),
      q(0104) => q(105),
      q(0105) => q(344),
      q(0106) => q(095),
      q(0107) => q(281),
      q(0108) => q(348),
      q(0109) => q(362),
      q(0110) => q(316),
      q(0111) => q(135),
      q(0112) => q(138),
      q(0113) => q(137),
      q(0114) => q(136),
      q(0115) => q(373),
      q(0116) => q(353),
      q(0117) => q(354),
      q(0118) => q(346),
      q(0119) => q(359),
      q(0120) => q(340),
      q(0121) => q(290),
      q(0122) => q(120),
      q(0123) => q(370),
      q(0124) => q(170),
      q(0125) => q(352),
      q(0126) => q(330),
      q(0127) => q(040),
      q(0128) => q(470),
      q(0129) => q(280),
      q(0130) => q(262),
      q(0131) => q(030),
      q(0132) => q(020),
      q(0133) => q(460),
      q(0134) => q(994),
      q(0135) => q(995),
      q(0136) => q(996),
      },
};

1;
