DROP TABLE IF EXISTS malware CASCADE;

CREATE TABLE malware (
    id BIGSERIAL PRIMARY KEY NOT NULL,
    uuid uuid NOT NULL REFERENCES message(uuid) ON DELETE CASCADE,
    description text,
    source uuid,
    hash_md5 varchar(32),
    hash_sha1 varchar(40),
    content bytea,
    impact VARCHAR(140),
    confidence REAL CHECK (confidence >= 0.0 AND 10.0 >= confidence),
    severity severity,
    restriction restriction not null default 'private',
    alternativeid text,
    alternativeid_restriction restriction not null default 'private',
    detecttime timestamp with time zone DEFAULT NOW(),
    created timestamp with time zone DEFAULT NOW(),
    UNIQUE (uuid)
);

CREATE TABLE malware_search () INHERITS (malware);
ALTER TABLE malware_search ADD PRIMARY KEY (id);
ALTER TABLE malware_search ADD CONSTRAINT malware_search_uuid_fkey FOREIGN KEY (uuid) REFERENCES message(uuid) ON DELETE CASCADE;
ALTER TABLE malware_search ADD UNIQUE(uuid);
