package CIF::Archive::Storage::Plugin::Iodef::Malware;

require XML::Malware;

sub prepare {
    my $class   = shift;
    my $info    = shift;

    return(undef) unless($info->{'impact'} eq 'malware');
    my $hash = $info->{'hash_md5'} || $info->{'hash_sha1'};
    $hash = lc($hash);
    return(undef) unless($hash && $hash =~ /^[a-f0-9]{32,40}$/);
    return(1);
}


sub convert {
    my $self = shift;
    my $info = shift;
    my $iodef = shift;
    
    return($iodef) unless($info->{'hash_md5'} || $info->{'hash_sha1'});

    my $source      = $info->{'source'};
    my $hash_md5    = $info->{'hash_md5'};
    my $hash_sha1   = $info->{'hash_sha1'};
    my $impact      = $info->{'impact'};
    my $restriction = $info->{'restriction'} || 'private';
    my $description = $info->{'description'};
    my $detecttime  = $info->{'detecttime'};

    my $h;
    $h->{'company'}     = $source;
    $h->{'author'}      = $source;
    $h->{'comment'}     = $description;
    $h->{'timestamp'}   = $detecttime;
    $h->{'id'}          = $hash_md5 || $hash_sha1 || '';

    push(@{$h->{'objects'}->{'file'}}, { id => $hash_md5, md5 => $hash_md5, sha1 => $hash_sha1 });
    push(@{$h->{'objects'}->{'classification'}}, { id => '', companyName => $source, type => 'dirty', classificationName => $impact});
    my $m = XML::Malware->new($h);

    $iodef->add('IncidentEventDataRecordRecordDataRecordItemdtype','xml');
    $iodef->add('IncidentEventDataRecordRecordDataRecordItemmeaning','malware sample');
    $iodef->add('IncidentEventDataRecordRecordDataRecordItemformatid','icsg1.1');
    $iodef->add('IncidentEventDataRecordRecordDataRecordItemrestriction',$restriction);
    $iodef->add('IncidentEventDataRecordRecordDataRecordItem',$m->out());

    return $iodef;
}

1;
