# Copyright (C) 1999 Bibliotech Ltd., 631-633 Fulham Rd., London SW6 5UQ.
#
# $Id: Net-FTPServer.spec.PL,v 1.12 2002/05/13 15:10:43 rich Exp $

use strict;

my $output = (@ARGV > 0 ? $ARGV[0] : "Net-FTPServer.spec");

unless (do "lib/Net/FTPServer.pm")
  {
    if ($@) { die $@ }
    die "lib/Net/FTPServer.pm: $!"
  }

local $/ = undef;
$_ = <DATA>;
s/\@VERSION\@/$Net::FTPServer::VERSION/g;
s/\@RELEASE\@/$Net::FTPServer::RELEASE/g;

open SPEC, ">$output" or die "$output: $!";
print SPEC $_;
close SPEC;

__DATA__
# Automatically generated by Net-FTPServer.spec.PL

%define perlsitearch %(perl -e 'use Config; print $Config{installsitearch}, "\\n"')
%define perlsitelib %(perl -e 'use Config; print $Config{installsitelib}, "\\n"')
%define perlman1dir %(perl -e 'use Config; print $Config{installman1dir}, "\\n"')
%define perlman3dir %(perl -e 'use Config; print $Config{installman3dir}, "\\n"')
%define perlversion %(perl -e 'use Config; print $Config{version}, "\\n"')

Summary: Net::FTPServer - an extensible, secure FTP server
Name: perl-Net-FTPServer
Version: @VERSION@
Release: @RELEASE@
Copyright: GPL
Group: Applications/Internet
Source: Net-FTPServer-%{version}.tar.gz
BuildRoot: /var/tmp/%{name}-%{version}-root
BuildRequires: perl-Authen-PAM >= 0.12
BuildRequires: perl-BSD-Resource >= 1.08
BuildRequires: perl-File-Sync >= 0.09
BuildRequires: perl-IO-stringy >= 1.220
BuildRequires: perl >= %{perlversion}
Requires: perl-Authen-PAM >= 0.12
Requires: perl-BSD-Resource >= 1.08
Requires: perl-File-Sync >= 0.09
Requires: perl-IO-stringy >= 1.220
Requires: perl >= %{perlversion}


%description


%prep
%setup -q -n Net-FTPServer-%{version}


%build
perl Makefile.PL
make
make test


%install
rm -rf $RPM_BUILD_ROOT
make NOCONF=1 PREFIX=$RPM_BUILD_ROOT/usr install

mkdir -p $RPM_BUILD_ROOT/usr/share/doc/Net-FTPServer-%{version}
cp AUTHORS COPYING FAQ INSTALL README TODO doc/* \
  $RPM_BUILD_ROOT/usr/share/doc/Net-FTPServer-%{version}


%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root)
%{perlsitearch}/auto/Net/FTPServer/
%{perlsitearch}/Net/FTPServer.pm
%{perlsitearch}/Net/FTPServer/
%{perlman3dir}/*.3*
/usr/sbin/*.pl
%config(noreplace) /etc/ftpd.conf
%doc /usr/share/doc/Net-FTPServer-%{version}/


%changelog
* Fri Dec 28 2001 Richard Jones <rich@annexia.org>
- Better handling of different Perl versions. RPM contains documentation,
- config file and start-up scripts.
* Tue Feb 15 2001 Rob Brown <rbrown@about-inc.com>
- Generalized files - works with Perl 5.6 as well as with Perl 5.005
* Tue Feb 08 2001 Richard Jones <rich@annexia.org>
- initial creation
