#!./perl
my $keep_c      = 0;	# set it to keep the pl, c and exe files
my $keep_c_fail = 1;	# set it to keep the pl, c and exe files on failures
# better use testc.sh for debugging
use Config;

BEGIN {
    if ($^O eq 'VMS') {
       print "1..0 # skip - B::C doesn't work on VMS\n";
       exit 0;
    }
    if ($ENV{PERL_CORE}){
	chdir('t') if -d 't';
	@INC = ('.', '../lib');
    } else {
	unshift @INC, 't';
	#push @INC, "blib/arch", "blib/lib";
    }
    if (($Config{'extensions'} !~ /\bB\b/) ){
        print "1..0 # Skip -- Perl configured without B module\n";
        exit 0;
    }
    #if ($Config{ccflags} =~ /-DPERL_COPY_ON_WRITE/) {
    #	print "1..0 # skip - no COW for now\n";
    #	exit 0;
    #}
    require 'test.pl'; # for run_perl()
}
use strict;
my $DEBUGGING = ($Config{ccflags} =~ m/-DDEBUGGING/);
my $ITHREADS  = ($Config{useithreads});
my $AUTHOR    = -d ".svn";

my @tests = tests();
my @todo  = (27);   # 8,14-16 fail on 5.00505 (max 20 then)
#@todo    = (27) if !$ITHREADS;
# 14+23 fixed with 1.04_29, for 5.10 with 1.04_31
# 15+28 fixed with 1.04_34
# 5.6.2 CORE: 8,15,16,22. 16 fixed with 1.04_24, 8 with 1.04_25
# 5.8.8 CORE: 11,14,15,20,23 / non-threaded: 5,7-12,14-20,22-23,25
@todo = (15,27)    if $] < 5.007;
@todo = ()         if $] >= 5.010; # 11 is instable
@todo = (15)       if $] >= 5.010 and $] < 5.011 and !$ITHREADS;
@todo = (15,16)    if $] >= 5.011;

my @skip = (27); # out of memory

my %todo = map { $_ => 1 } @todo;
my %skip = map { $_ => 1 } @skip;

print "1..".($#tests+1)."\n";

my $cnt = 1;
for (@tests) {
  my $todo = $todo{$cnt} ? "#TODO" : "#";
  if ($todo{$cnt} and $skip{$cnt} and !$AUTHOR) {
    print sprintf("ok %d # skip\n", $cnt);
  } else {
    my ($script, $expect) = split />>>+\n/;
    run_cc_test($cnt, "C", $script, $expect, $keep_c, $keep_c_fail, $todo);
  }
  $cnt++;
}
