/* -*- buffer-read-only: t -*-
 *
 *      Copyright (c) 1996-1999 Malcolm Beattie
 *      Copyright (c) 2008 Reini Urban
 *
 *      You may distribute under the terms of either the GNU General Public
 *      License or the Artistic License, as specified in the README file.
 *
 */
/*
 * This file is autogenerated from bytecode.pl. Changes made here will be lost.
 */

#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#include "perl.h"
#define NO_XSLOCKS
#include "XSUB.h"
#if PERL_VERSION < 8
  #define NEED_sv_2pv_flags
  #include "ppport.h"
#endif

/* Change 31252: move PL_tokenbuf into the PL_parser struct */
#if (PERL_VERSION > 8) && (!defined(PL_tokenbuf))
  #define PL_tokenbuf		(PL_parser->tokenbuf)
#endif
#if (PERL_VERSION < 8) && (!defined(DEBUG_v))
  #define DEBUG_v(a) DEBUG_l(a)
#endif

#include "byterun.h"
#include "bytecode.h"

static const int optype_size[] = {
    sizeof(OP),
    sizeof(UNOP),
    sizeof(BINOP),
    sizeof(LOGOP),
    sizeof(LISTOP),
    sizeof(PMOP),
    sizeof(SVOP),
    sizeof(PADOP),
    sizeof(PVOP),
    sizeof(LOOP),
    sizeof(COP)
};

void *
bset_obj_store(pTHX_ struct byteloader_state *bstate, void *obj, I32 ix)
{
    if (ix > bstate->bs_obj_list_fill) {
	Renew(bstate->bs_obj_list, ix + 32, void*);
	bstate->bs_obj_list_fill = ix + 31;
    }
    bstate->bs_obj_list[ix] = obj;
    return obj;
}

int bytecode_header_check(pTHX_ struct byteloader_state *bstate, U32 *isjit) {
    U32 sz = 0;
    strconst str;

    BGET_U32(sz); /* Magic: 'PLBC' or 'PLJC' */
    if (sz != 0x43424c50) {
        if (sz != 0x434a4c50) {
	    HEADER_FAIL1("bad magic (want 0x43424c50 PLBC or 0x434a4c50 PLJC, got %#x)", (int)sz);
	} else {
	    *isjit = 1;
        }
    }
    BGET_strconst(str,80);	/* archname */
    /* just warn. relaxed strictness, only check for ithread in archflag */
    if (strNE(str, ARCHNAME)) {
	HEADER_WARN2("wrong architecture (want %s, you have %s)", str, ARCHNAME);
    }
    strcpy(bl_header.archname, str);

    BGET_strconst(str,16); /* fail if different ByteLoader version */
    if (strNE(str, VERSION)) {
	HEADER_FAIL2("mismatched ByteLoader versions (want %s, you have %s)",
		str, VERSION);
    }
    strcpy(bl_header.version, str);

    BGET_U32(sz); /* ivsize */
    bl_header.ivsize = sz;

    BGET_U32(sz); /* ptrsize */
    bl_header.ptrsize = sz;

    /* new since 0.06_03 */
    if (strGE(bl_header.version, "0.06_03")) {
      BGET_U32(sz); /* longsize */
      bl_header.longsize = sz;
    } else {
      bl_header.longsize = LONGSIZE;
    }

    {
      char supported[8]; /* config.h BYTEORDER: 0x1234 */
      sprintf(supported, "%x", BYTEORDER);
      BGET_strconst(str, 16); /* 12345678 or 1234 */
      if (strNE(str, supported)) {
        bget_swab = 1;
	HEADER_WARN2("EXPERIMENTAL: Convert byteorder.  Bytecode: %s, System: %s",
		     str, supported);
      }
      strcpy(bl_header.byteorder, str);
    }

    /* check byteorder */
    if (bget_swab) {
	bl_header.ivsize = _swab_32_(bl_header.ivsize);
	bl_header.ptrsize = _swab_32_(bl_header.ptrsize);
        if (bl_header.longsize != LONGSIZE) {
	    bl_header.longsize = _swab_32_(bl_header.longsize);
        }
    }

#ifdef USE_ITHREADS
# define HAVE_ITHREADS_I 1
#else
# define HAVE_ITHREADS_I 0
#endif
    if (strGE(bl_header.version, "0.06_05")) {
      BGET_U16(sz); /* archflag */
      bl_header.archflag = sz;
      if ((sz & 1) != HAVE_ITHREADS_I) {
	HEADER_FAIL2("Wrong USE_ITHREADS. Bytecode: %s, System: %s)",
		     bl_header.archflag & 1 ? "yes" : "no", HAVE_ITHREADS_I ? "yes" : "no");
      }
    }

    if (bl_header.ivsize != IVSIZE) {
	HEADER_WARN("different IVSIZE");
        if ((bl_header.ivsize != 4) && (bl_header.ivsize != 8))
	    HEADER_FAIL1("unsupported IVSIZE %d", bl_header.ivsize);
    }
    if (bl_header.ptrsize != PTRSIZE) {
	HEADER_WARN("different PTRSIZE");
        if ((bl_header.ptrsize != 4) && (bl_header.ptrsize != 8))
	    HEADER_FAIL1("unsupported PTRSIZE %d", bl_header.ptrsize);
    }
    if (strGE(bl_header.version, "0.06_03")) {
      if (bl_header.longsize != LONGSIZE) {
	HEADER_WARN("different LONGSIZE");
        if ((bl_header.longsize != 4) && (bl_header.longsize != 8))
	    HEADER_FAIL1("unsupported LONGSIZE %d", bl_header.longsize);
      }
    }

    return 1;
}

int
byterun(pTHX_ struct byteloader_state *bstate)
{
    register int insn;
    U32 isjit = 0;
    U32 ix;
    SV *specialsv_list[6];

    bytecode_header_check(aTHX_ bstate, &isjit); /* croak if incorrect platform,
						    set isjit on PLJC magic header */
    if (isjit) {
	Perl_croak(aTHX_ "PLJC-magic: No JIT support yet\n");
        return 0; /*jitrun(aTHX_ &bstate);*/
    } else {
        New(0, bstate->bs_obj_list, 32, void*); /* set op objlist */
        bstate->bs_obj_list_fill = 31;
        bstate->bs_obj_list[0] = NULL;          /* first is always Null */
        bstate->bs_ix = 1;
	CopLINE(PL_curcop) = bstate->bs_fdata->next_out;
	DEBUG_l( Perl_deb(aTHX_ "(bstate.bs_fdata.idx %d)\n", bstate->bs_fdata->idx));
	DEBUG_l( Perl_deb(aTHX_ "(bstate.bs_fdata.next_out %d)\n", bstate->bs_fdata->next_out));
	DEBUG_l( Perl_deb(aTHX_ "(bstate.bs_fdata.datasv %p:\"%s\")\n", bstate->bs_fdata->datasv,
				 SvPV_nolen(bstate->bs_fdata->datasv)));

        specialsv_list[0] = Nullsv;
        specialsv_list[1] = &PL_sv_undef;
        specialsv_list[2] = &PL_sv_yes;
        specialsv_list[3] = &PL_sv_no;
        specialsv_list[4] = pWARN_ALL;
        specialsv_list[5] = pWARN_NONE;

        while ((insn = BGET_FGETC()) != EOF) {
	  CopLINE(PL_curcop) = bstate->bs_fdata->next_out;
	  switch (insn) {
	  case INSN_COMMENT:		/* 35 */
	    {
		comment_t arg;
		BGET_comment_t(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) comment comment_t:%d\n", insn, arg));
		arg = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   arg = arg;\n"));
		break;
	    }
	  case INSN_NOP:		/* 10 */
	    {
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) nop\n", insn));
		break;
	    }
	  case INSN_RET:		/* 0 */
	    {
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) ret\n", insn));
		BSET_ret(none);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_ret(none)\n"));
		break;
	    }
	  case INSN_LDSV:		/* 1 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) ldsv svindex:0x%x, ix:%d\n", insn, arg, ix));
		bstate->bs_sv = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   bstate->bs_sv = arg;\n"));
		break;
	    }
	  case INSN_LDOP:		/* 2 */
	    {
		opindex arg;
		BGET_opindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) ldop opindex:0x%x, ix:%d\n", insn, arg, ix));
		PL_op = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   PL_op = arg;\n"));
		break;
	    }
	  case INSN_STSV:		/* 3 */
	    {
		U32 arg;
		BGET_U32(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) stsv U32:%d\n", insn, arg));
		BSET_OBJ_STORE(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_OBJ_STORE(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_STOP:		/* 4 */
	    {
		U32 arg;
		BGET_U32(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) stop U32:%d\n", insn, arg));
		BSET_OBJ_STORE(PL_op, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_OBJ_STORE(PL_op, arg)\n"));
		break;
	    }
	  case INSN_STPV:		/* 5 */
	    {
		U32 arg;
		BGET_U32(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) stpv U32:%d\n", insn, arg));
		BSET_stpv(bstate->bs_pv.xpv_pv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_stpv(bstate->bs_pv.xpv_pv, arg)\n"));
		break;
	    }
	  case INSN_LDSPECSV:		/* 6 */
	    {
		U8 arg;
		BGET_U8(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) ldspecsv U8:%d\n", insn, arg));
		BSET_ldspecsv(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_ldspecsv(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_LDSPECSVX:		/* 7 */
	    {
		U8 arg;
		BGET_U8(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) ldspecsvx U8:%d\n", insn, arg));
		BSET_ldspecsvx(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_ldspecsvx(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_NEWSV:		/* 8 */
	    {
		U8 arg;
		BGET_U8(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) newsv U8:%d\n", insn, arg));
		BSET_newsv(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_newsv(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_NEWSVX:		/* 9 */
	    {
		U32 arg;
		BGET_U32(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) newsvx U32:%d\n", insn, arg));
		BSET_newsvx(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_newsvx(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_NEWOP:		/* 11 */
	    {
		U8 arg;
		BGET_U8(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) newop U8:%d\n", insn, arg));
		BSET_newop(PL_op, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_newop(PL_op, arg)\n"));
		break;
	    }
	  case INSN_NEWOPX:		/* 12 */
	    {
		U16 arg;
		BGET_U16(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) newopx U16:%d\n", insn, arg));
		BSET_newopx(PL_op, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_newopx(PL_op, arg)\n"));
		break;
	    }
	  case INSN_NEWOPN:		/* 13 */
	    {
		U8 arg;
		BGET_U8(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) newopn U8:%d\n", insn, arg));
		BSET_newopn(PL_op, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_newopn(PL_op, arg)\n"));
		break;
	    }
	  case INSN_NEWPV:		/* 14 */
	    {
		PV arg;
		BGET_PV(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) newpv PV:%d\n", insn, arg));
		DEBUG_v(Perl_deb(aTHX_ "	   BGET_PV(arg) => \"%s\"\n", bstate->bs_pv.xpv_pv));
		break;
	    }
	  case INSN_PV_CUR:		/* 15 */
	    {
		STRLEN arg;
		BGET_PADOFFSET(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) pv_cur STRLEN:%d\n", insn, arg));
		bstate->bs_pv.xpv_cur = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   bstate->bs_pv.xpv_cur = arg;\n"));
		break;
	    }
	  case INSN_PV_FREE:		/* 16 */
	    {
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) pv_free\n", insn));
		BSET_pv_free(bstate->bs_pv);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_pv_free(bstate->bs_pv)\n"));
		break;
	    }
	  case INSN_SV_UPGRADE:		/* 17 */
	    {
		U8 arg;
		BGET_U8(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) sv_upgrade U8:%d\n", insn, arg));
		BSET_sv_upgrade(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_sv_upgrade(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_SV_REFCNT:		/* 18 */
	    {
		U32 arg;
		BGET_U32(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) sv_refcnt U32:%d\n", insn, arg));
		SvREFCNT(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   SvREFCNT(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_SV_REFCNT_ADD:		/* 19 */
	    {
		I32 arg;
		BGET_I32(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) sv_refcnt_add I32:%d\n", insn, arg));
		BSET_sv_refcnt_add(SvREFCNT(bstate->bs_sv), arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_sv_refcnt_add(SvREFCNT(bstate->bs_sv), arg)\n"));
		break;
	    }
	  case INSN_SV_FLAGS:		/* 20 */
	    {
		U32 arg;
		BGET_U32(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) sv_flags U32:%d\n", insn, arg));
		SvFLAGS(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   SvFLAGS(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XRV:		/* 21 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xrv svindex:0x%x, ix:%d\n", insn, arg, ix));
		BSET_xrv(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_xrv(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_XPV:		/* 22 */
	    {
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xpv\n", insn));
		BSET_xpv(bstate->bs_sv);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_xpv(bstate->bs_sv)\n"));
		break;
	    }
	  case INSN_XPV_CUR:		/* 23 */
	    {
		STRLEN arg;
		BGET_PADOFFSET(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xpv_cur STRLEN:%d\n", insn, arg));
		BSET_xpv_cur(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_xpv_cur(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_XPV_LEN:		/* 24 */
	    {
		STRLEN arg;
		BGET_PADOFFSET(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xpv_len STRLEN:%d\n", insn, arg));
		BSET_xpv_len(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_xpv_len(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_XIV:		/* 25 */
	    {
		IV arg;
		BGET_IV(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xiv IV:%d\n", insn, arg));
		BSET_xiv(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_xiv(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_XNV:		/* 26 */
	    {
		NV arg;
		BGET_NV(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xnv NV:%d\n", insn, arg));
		BSET_xnv(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_xnv(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_XLV_TARGOFF:		/* 27 */
	    {
		STRLEN arg;
		BGET_PADOFFSET(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xlv_targoff STRLEN:%d\n", insn, arg));
		LvTARGOFF(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   LvTARGOFF(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XLV_TARGLEN:		/* 28 */
	    {
		STRLEN arg;
		BGET_PADOFFSET(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xlv_targlen STRLEN:%d\n", insn, arg));
		LvTARGLEN(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   LvTARGLEN(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XLV_TARG:		/* 29 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xlv_targ svindex:0x%x, ix:%d\n", insn, arg, ix));
		LvTARG(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   LvTARG(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XLV_TYPE:		/* 30 */
	    {
		char arg;
		BGET_U8(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xlv_type char:%d\n", insn, arg));
		LvTYPE(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   LvTYPE(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XBM_USEFUL:		/* 31 */
	    {
		I32 arg;
		BGET_I32(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xbm_useful I32:%d\n", insn, arg));
		BmUSEFUL(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   BmUSEFUL(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XBM_PREVIOUS:		/* 32 */
	    {
		U16 arg;
		BGET_U16(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xbm_previous U16:%d\n", insn, arg));
		BmPREVIOUS(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   BmPREVIOUS(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XBM_RARE:		/* 33 */
	    {
		U8 arg;
		BGET_U8(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xbm_rare U8:%d\n", insn, arg));
		BmRARE(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   BmRARE(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XFM_LINES:		/* 34 */
	    {
		IV arg;
		BGET_IV(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xfm_lines IV:%d\n", insn, arg));
		FmLINES(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   FmLINES(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XIO_LINES:		/* 36 */
	    {
		IV arg;
		BGET_IV(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xio_lines IV:%d\n", insn, arg));
		IoLINES(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   IoLINES(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XIO_PAGE:		/* 37 */
	    {
		IV arg;
		BGET_IV(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xio_page IV:%d\n", insn, arg));
		IoPAGE(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   IoPAGE(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XIO_PAGE_LEN:		/* 38 */
	    {
		IV arg;
		BGET_IV(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xio_page_len IV:%d\n", insn, arg));
		IoPAGE_LEN(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   IoPAGE_LEN(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XIO_LINES_LEFT:		/* 39 */
	    {
		IV arg;
		BGET_IV(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xio_lines_left IV:%d\n", insn, arg));
		IoLINES_LEFT(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   IoLINES_LEFT(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XIO_TOP_NAME:		/* 40 */
	    {
		pvindex arg;
		BGET_pvindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xio_top_name pvindex:\"%s\"\n", insn, arg, ix));
		IoTOP_NAME(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   IoTOP_NAME(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XIO_TOP_GV:		/* 41 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xio_top_gv svindex:0x%x, ix:%d\n", insn, arg, ix));
		*(SV**)&IoTOP_GV(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   *(SV**)&IoTOP_GV(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XIO_FMT_NAME:		/* 42 */
	    {
		pvindex arg;
		BGET_pvindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xio_fmt_name pvindex:\"%s\"\n", insn, arg, ix));
		IoFMT_NAME(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   IoFMT_NAME(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XIO_FMT_GV:		/* 43 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xio_fmt_gv svindex:0x%x, ix:%d\n", insn, arg, ix));
		*(SV**)&IoFMT_GV(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   *(SV**)&IoFMT_GV(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XIO_BOTTOM_NAME:		/* 44 */
	    {
		pvindex arg;
		BGET_pvindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xio_bottom_name pvindex:\"%s\"\n", insn, arg, ix));
		IoBOTTOM_NAME(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   IoBOTTOM_NAME(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XIO_BOTTOM_GV:		/* 45 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xio_bottom_gv svindex:0x%x, ix:%d\n", insn, arg, ix));
		*(SV**)&IoBOTTOM_GV(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   *(SV**)&IoBOTTOM_GV(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XIO_SUBPROCESS:		/* 46 */
	    {
		short arg;
		BGET_U16(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xio_subprocess short:%d\n", insn, arg));
		IoSUBPROCESS(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   IoSUBPROCESS(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XIO_TYPE:		/* 47 */
	    {
		char arg;
		BGET_U8(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xio_type char:%d\n", insn, arg));
		IoTYPE(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   IoTYPE(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XIO_FLAGS:		/* 48 */
	    {
		char arg;
		BGET_U8(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xio_flags char:%d\n", insn, arg));
		IoFLAGS(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   IoFLAGS(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XCV_XSUBANY:		/* 49 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xcv_xsubany svindex:0x%x, ix:%d\n", insn, arg, ix));
		*(SV**)&CvXSUBANY(bstate->bs_sv).any_ptr = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   *(SV**)&CvXSUBANY(bstate->bs_sv).any_ptr = arg;\n"));
		break;
	    }
	  case INSN_XCV_STASH:		/* 50 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xcv_stash svindex:0x%x, ix:%d\n", insn, arg, ix));
		*(SV**)&CvSTASH(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   *(SV**)&CvSTASH(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XCV_START:		/* 51 */
	    {
		opindex arg;
		BGET_opindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xcv_start opindex:0x%x, ix:%d\n", insn, arg, ix));
		CvSTART(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   CvSTART(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XCV_ROOT:		/* 52 */
	    {
		opindex arg;
		BGET_opindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xcv_root opindex:0x%x, ix:%d\n", insn, arg, ix));
		CvROOT(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   CvROOT(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XCV_GV:		/* 53 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xcv_gv svindex:0x%x, ix:%d\n", insn, arg, ix));
		*(SV**)&CvGV(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   *(SV**)&CvGV(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XCV_FILE:		/* 54 */
	    {
		pvindex arg;
		BGET_pvindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xcv_file pvindex:\"%s\"\n", insn, arg, ix));
		CvFILE(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   CvFILE(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XCV_DEPTH:		/* 55 */
	    {
		long arg;
		BGET_long(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xcv_depth long:%d\n", insn, arg));
		CvDEPTH(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   CvDEPTH(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XCV_PADLIST:		/* 56 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xcv_padlist svindex:0x%x, ix:%d\n", insn, arg, ix));
		*(SV**)&CvPADLIST(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   *(SV**)&CvPADLIST(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XCV_OUTSIDE:		/* 57 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xcv_outside svindex:0x%x, ix:%d\n", insn, arg, ix));
		*(SV**)&CvOUTSIDE(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   *(SV**)&CvOUTSIDE(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XCV_OUTSIDE_SEQ:		/* 58 */
	    {
		U32 arg;
		BGET_U32(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xcv_outside_seq U32:%d\n", insn, arg));
		CvOUTSIDE_SEQ(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   CvOUTSIDE_SEQ(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XCV_FLAGS:		/* 59 */
	    {
		U16 arg;
		BGET_U16(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xcv_flags U16:%d\n", insn, arg));
		CvFLAGS(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   CvFLAGS(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_AV_EXTEND:		/* 60 */
	    {
		SSize_t arg;
		BGET_PADOFFSET(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) av_extend SSize_t:%d\n", insn, arg));
		BSET_av_extend(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_av_extend(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_AV_PUSHX:		/* 61 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) av_pushx svindex:0x%x, ix:%d\n", insn, arg, ix));
		BSET_av_pushx(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_av_pushx(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_AV_PUSH:		/* 62 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) av_push svindex:0x%x, ix:%d\n", insn, arg, ix));
		BSET_av_push(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_av_push(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_XAV_FILL:		/* 63 */
	    {
		SSize_t arg;
		BGET_PADOFFSET(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xav_fill SSize_t:%d\n", insn, arg));
		AvFILLp(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   AvFILLp(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XAV_MAX:		/* 64 */
	    {
		SSize_t arg;
		BGET_PADOFFSET(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xav_max SSize_t:%d\n", insn, arg));
		AvMAX(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   AvMAX(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XAV_FLAGS:		/* 65 */
	    {
		U8 arg;
		BGET_U8(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xav_flags U8:%d\n", insn, arg));
		AvFLAGS(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   AvFLAGS(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XHV_RITER:		/* 66 */
	    {
		I32 arg;
		BGET_I32(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xhv_riter I32:%d\n", insn, arg));
		HvRITER(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   HvRITER(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_XHV_NAME:		/* 67 */
	    {
		pvindex arg;
		BGET_pvindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xhv_name pvindex:\"%s\"\n", insn, arg, ix));
		BSET_xhv_name(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_xhv_name(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_XHV_PMROOT:		/* 68 */
	    {
		opindex arg;
		BGET_opindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xhv_pmroot opindex:0x%x, ix:%d\n", insn, arg, ix));
		*(OP**)&HvPMROOT(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   *(OP**)&HvPMROOT(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_HV_STORE:		/* 69 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) hv_store svindex:0x%x, ix:%d\n", insn, arg, ix));
		BSET_hv_store(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_hv_store(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_SV_MAGIC:		/* 70 */
	    {
		char arg;
		BGET_U8(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) sv_magic char:%d\n", insn, arg));
		BSET_sv_magic(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_sv_magic(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_MG_OBJ:		/* 71 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) mg_obj svindex:0x%x, ix:%d\n", insn, arg, ix));
		SvMAGIC(bstate->bs_sv)->mg_obj = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   SvMAGIC(bstate->bs_sv)->mg_obj = arg;\n"));
		break;
	    }
	  case INSN_MG_PRIVATE:		/* 72 */
	    {
		U16 arg;
		BGET_U16(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) mg_private U16:%d\n", insn, arg));
		SvMAGIC(bstate->bs_sv)->mg_private = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   SvMAGIC(bstate->bs_sv)->mg_private = arg;\n"));
		break;
	    }
	  case INSN_MG_FLAGS:		/* 73 */
	    {
		U8 arg;
		BGET_U8(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) mg_flags U8:%d\n", insn, arg));
		SvMAGIC(bstate->bs_sv)->mg_flags = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   SvMAGIC(bstate->bs_sv)->mg_flags = arg;\n"));
		break;
	    }
	  case INSN_MG_NAME:		/* 74 */
	    {
		pvcontents arg;
		BGET_pvcontents(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) mg_name pvcontents:\"%s\"\n", insn, arg));
		BSET_mg_name(SvMAGIC(bstate->bs_sv), arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_mg_name(SvMAGIC(bstate->bs_sv), arg)\n"));
		break;
	    }
	  case INSN_MG_NAMEX:		/* 75 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) mg_namex svindex:0x%x, ix:%d\n", insn, arg, ix));
		BSET_mg_namex(SvMAGIC(bstate->bs_sv), arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_mg_namex(SvMAGIC(bstate->bs_sv), arg)\n"));
		break;
	    }
	  case INSN_XMG_STASH:		/* 76 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xmg_stash svindex:0x%x, ix:%d\n", insn, arg, ix));
		BSET_xmg_stash(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_xmg_stash(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_GV_FETCHPV:		/* 77 */
	    {
		strconst arg;
		BGET_strconst(arg, 0);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) gv_fetchpv strconst:\"%s\"\n", insn, arg));
		BSET_gv_fetchpv(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_gv_fetchpv(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_GV_FETCHPVX:		/* 78 */
	    {
		strconst arg;
		BGET_strconst(arg, 0);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) gv_fetchpvx strconst:\"%s\"\n", insn, arg));
		BSET_gv_fetchpvx(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_gv_fetchpvx(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_GV_STASHPV:		/* 79 */
	    {
		strconst arg;
		BGET_strconst(arg, 0);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) gv_stashpv strconst:\"%s\"\n", insn, arg));
		BSET_gv_stashpv(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_gv_stashpv(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_GV_STASHPVX:		/* 80 */
	    {
		strconst arg;
		BGET_strconst(arg, 0);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) gv_stashpvx strconst:\"%s\"\n", insn, arg));
		BSET_gv_stashpvx(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_gv_stashpvx(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_GP_SV:		/* 81 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) gp_sv svindex:0x%x, ix:%d\n", insn, arg, ix));
		BSET_gp_sv(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_gp_sv(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_GP_REFCNT:		/* 82 */
	    {
		U32 arg;
		BGET_U32(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) gp_refcnt U32:%d\n", insn, arg));
		GvREFCNT(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   GvREFCNT(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_GP_REFCNT_ADD:		/* 83 */
	    {
		I32 arg;
		BGET_I32(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) gp_refcnt_add I32:%d\n", insn, arg));
		BSET_gp_refcnt_add(GvREFCNT(bstate->bs_sv), arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_gp_refcnt_add(GvREFCNT(bstate->bs_sv), arg)\n"));
		break;
	    }
	  case INSN_GP_AV:		/* 84 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) gp_av svindex:0x%x, ix:%d\n", insn, arg, ix));
		*(SV**)&GvAV(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   *(SV**)&GvAV(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_GP_HV:		/* 85 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) gp_hv svindex:0x%x, ix:%d\n", insn, arg, ix));
		*(SV**)&GvHV(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   *(SV**)&GvHV(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_GP_CV:		/* 86 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) gp_cv svindex:0x%x, ix:%d\n", insn, arg, ix));
		*(SV**)&GvCV(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   *(SV**)&GvCV(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_GP_FILE:		/* 87 */
	    {
		pvindex arg;
		BGET_pvindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) gp_file pvindex:\"%s\"\n", insn, arg, ix));
		GvFILE(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   GvFILE(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_GP_IO:		/* 88 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) gp_io svindex:0x%x, ix:%d\n", insn, arg, ix));
		*(SV**)&GvIOp(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   *(SV**)&GvIOp(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_GP_FORM:		/* 89 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) gp_form svindex:0x%x, ix:%d\n", insn, arg, ix));
		*(SV**)&GvFORM(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   *(SV**)&GvFORM(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_GP_CVGEN:		/* 90 */
	    {
		U32 arg;
		BGET_U32(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) gp_cvgen U32:%d\n", insn, arg));
		GvCVGEN(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   GvCVGEN(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_GP_LINE:		/* 91 */
	    {
		line_t arg;
		BGET_U32(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) gp_line line_t:%d\n", insn, arg));
		GvLINE(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   GvLINE(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_GP_SHARE:		/* 92 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) gp_share svindex:0x%x, ix:%d\n", insn, arg, ix));
		BSET_gp_share(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_gp_share(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_XGV_FLAGS:		/* 93 */
	    {
		U8 arg;
		BGET_U8(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xgv_flags U8:%d\n", insn, arg));
		GvFLAGS(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   GvFLAGS(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_OP_NEXT:		/* 94 */
	    {
		opindex arg;
		BGET_opindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_next opindex:0x%x, ix:%d\n", insn, arg, ix));
		PL_op->op_next = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   PL_op->op_next = arg;\n"));
		break;
	    }
	  case INSN_OP_SIBLING:		/* 95 */
	    {
		opindex arg;
		BGET_opindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_sibling opindex:0x%x, ix:%d\n", insn, arg, ix));
		PL_op->op_sibling = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   PL_op->op_sibling = arg;\n"));
		break;
	    }
	  case INSN_OP_PPADDR:		/* 96 */
	    {
		strconst arg;
		BGET_strconst(arg, 0);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_ppaddr strconst:\"%s\"\n", insn, arg));
		BSET_op_ppaddr(PL_op->op_ppaddr, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_op_ppaddr(PL_op->op_ppaddr, arg)\n"));
		break;
	    }
	  case INSN_OP_TARG:		/* 97 */
	    {
		PADOFFSET arg;
		BGET_PADOFFSET(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_targ PADOFFSET:%d\n", insn, arg));
		PL_op->op_targ = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   PL_op->op_targ = arg;\n"));
		break;
	    }
	  case INSN_OP_TYPE:		/* 98 */
	    {
		OPCODE arg;
		BGET_U16(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_type OPCODE:%d\n", insn, arg));
		BSET_op_type(PL_op, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_op_type(PL_op, arg)\n"));
		break;
	    }
	  case INSN_OP_SEQ:		/* 99 */
	    {
		U16 arg;
		BGET_U16(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_seq U16:%d\n", insn, arg));
		PL_op->op_seq = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   PL_op->op_seq = arg;\n"));
		break;
	    }
	  case INSN_OP_FLAGS:		/* 100 */
	    {
		U8 arg;
		BGET_U8(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_flags U8:%d\n", insn, arg));
		PL_op->op_flags = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   PL_op->op_flags = arg;\n"));
		break;
	    }
	  case INSN_OP_PRIVATE:		/* 101 */
	    {
		U8 arg;
		BGET_U8(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_private U8:%d\n", insn, arg));
		PL_op->op_private = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   PL_op->op_private = arg;\n"));
		break;
	    }
	  case INSN_OP_FIRST:		/* 102 */
	    {
		opindex arg;
		BGET_opindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_first opindex:0x%x, ix:%d\n", insn, arg, ix));
		cUNOP->op_first = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   cUNOP->op_first = arg;\n"));
		break;
	    }
	  case INSN_OP_LAST:		/* 103 */
	    {
		opindex arg;
		BGET_opindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_last opindex:0x%x, ix:%d\n", insn, arg, ix));
		cBINOP->op_last = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   cBINOP->op_last = arg;\n"));
		break;
	    }
	  case INSN_OP_OTHER:		/* 104 */
	    {
		opindex arg;
		BGET_opindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_other opindex:0x%x, ix:%d\n", insn, arg, ix));
		cLOGOP->op_other = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   cLOGOP->op_other = arg;\n"));
		break;
	    }
	  case INSN_OP_PMREPLROOT:		/* 105 */
	    {
		opindex arg;
		BGET_opindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_pmreplroot opindex:0x%x, ix:%d\n", insn, arg, ix));
		cPMOP->op_pmreplroot = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   cPMOP->op_pmreplroot = arg;\n"));
		break;
	    }
	  case INSN_OP_PMREPLSTART:		/* 106 */
	    {
		opindex arg;
		BGET_opindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_pmreplstart opindex:0x%x, ix:%d\n", insn, arg, ix));
		cPMOP->op_pmreplstart = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   cPMOP->op_pmreplstart = arg;\n"));
		break;
	    }
	  case INSN_OP_PMNEXT:		/* 107 */
	    {
		opindex arg;
		BGET_opindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_pmnext opindex:0x%x, ix:%d\n", insn, arg, ix));
		*(OP**)&cPMOP->op_pmnext = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   *(OP**)&cPMOP->op_pmnext = arg;\n"));
		break;
	    }
#ifdef USE_ITHREADS
	  case INSN_OP_PMSTASHPV:		/* 108 */
	    {
		pvindex arg;
		BGET_pvindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_pmstashpv pvindex:\"%s\"\n", insn, arg, ix));
		BSET_op_pmstashpv(cPMOP, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_op_pmstashpv(cPMOP, arg)\n"));
		break;
	    }
	  case INSN_OP_PMREPLROOTPO:		/* 109 */
	    {
		PADOFFSET arg;
		BGET_PADOFFSET(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_pmreplrootpo PADOFFSET:%d\n", insn, arg));
		cPMOP->op_pmreplroot = (OP*)arg;
		DEBUG_v(Perl_deb(aTHX_ "	   cPMOP->op_pmreplroot = (OP*)arg;\n"));
		break;
	    }
#else
	  case INSN_OP_PMSTASH:		/* 110 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_pmstash svindex:0x%x, ix:%d\n", insn, arg, ix));
		*(SV**)&cPMOP->op_pmstash = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   *(SV**)&cPMOP->op_pmstash = arg;\n"));
		break;
	    }
	  case INSN_OP_PMREPLROOTGV:		/* 111 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_pmreplrootgv svindex:0x%x, ix:%d\n", insn, arg, ix));
		*(SV**)&cPMOP->op_pmreplroot = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   *(SV**)&cPMOP->op_pmreplroot = arg;\n"));
		break;
	    }
#endif
	  case INSN_PREGCOMP:		/* 112 */
	    {
		pvcontents arg;
		BGET_pvcontents(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) pregcomp pvcontents:\"%s\"\n", insn, arg));
		BSET_pregcomp(PL_op, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_pregcomp(PL_op, arg)\n"));
		break;
	    }
	  case INSN_OP_PMFLAGS:		/* 113 */
	    {
		U16 arg;
		BGET_U16(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_pmflags U16:%d\n", insn, arg));
		cPMOP->op_pmflags = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   cPMOP->op_pmflags = arg;\n"));
		break;
	    }
	  case INSN_OP_PMPERMFLAGS:		/* 114 */
	    {
		U16 arg;
		BGET_U16(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_pmpermflags U16:%d\n", insn, arg));
		cPMOP->op_pmpermflags = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   cPMOP->op_pmpermflags = arg;\n"));
		break;
	    }
	  case INSN_OP_PMDYNFLAGS:		/* 115 */
	    {
		U8 arg;
		BGET_U8(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_pmdynflags U8:%d\n", insn, arg));
		cPMOP->op_pmdynflags = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   cPMOP->op_pmdynflags = arg;\n"));
		break;
	    }
	  case INSN_OP_SV:		/* 116 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_sv svindex:0x%x, ix:%d\n", insn, arg, ix));
		cSVOP->op_sv = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   cSVOP->op_sv = arg;\n"));
		break;
	    }
	  case INSN_OP_PADIX:		/* 117 */
	    {
		PADOFFSET arg;
		BGET_PADOFFSET(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_padix PADOFFSET:%d\n", insn, arg));
		cPADOP->op_padix = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   cPADOP->op_padix = arg;\n"));
		break;
	    }
	  case INSN_OP_PV:		/* 118 */
	    {
		pvcontents arg;
		BGET_pvcontents(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_pv pvcontents:\"%s\"\n", insn, arg));
		cPVOP->op_pv = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   cPVOP->op_pv = arg;\n"));
		break;
	    }
	  case INSN_OP_PV_TR:		/* 119 */
	    {
		op_tr_array arg;
		BGET_op_tr_array(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_pv_tr op_tr_array:%d\n", insn, arg));
		cPVOP->op_pv = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   cPVOP->op_pv = arg;\n"));
		break;
	    }
	  case INSN_OP_REDOOP:		/* 120 */
	    {
		opindex arg;
		BGET_opindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_redoop opindex:0x%x, ix:%d\n", insn, arg, ix));
		cLOOP->op_redoop = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   cLOOP->op_redoop = arg;\n"));
		break;
	    }
	  case INSN_OP_NEXTOP:		/* 121 */
	    {
		opindex arg;
		BGET_opindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_nextop opindex:0x%x, ix:%d\n", insn, arg, ix));
		cLOOP->op_nextop = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   cLOOP->op_nextop = arg;\n"));
		break;
	    }
	  case INSN_OP_LASTOP:		/* 122 */
	    {
		opindex arg;
		BGET_opindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) op_lastop opindex:0x%x, ix:%d\n", insn, arg, ix));
		cLOOP->op_lastop = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   cLOOP->op_lastop = arg;\n"));
		break;
	    }
	  case INSN_COP_LABEL:		/* 123 */
	    {
		pvindex arg;
		BGET_pvindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) cop_label pvindex:\"%s\"\n", insn, arg, ix));
		BSET_cop_label(cCOP, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_cop_label(cCOP, arg)\n"));
		break;
	    }
	  case INSN_COP_STASHPV:		/* 124 */
	    {
		pvindex arg;
		BGET_pvindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) cop_stashpv pvindex:\"%s\"\n", insn, arg, ix));
		BSET_cop_stashpv(cCOP, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_cop_stashpv(cCOP, arg)\n"));
		break;
	    }
	  case INSN_COP_FILE:		/* 125 */
	    {
		pvindex arg;
		BGET_pvindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) cop_file pvindex:\"%s\"\n", insn, arg, ix));
		BSET_cop_file(cCOP, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_cop_file(cCOP, arg)\n"));
		break;
	    }
#ifndef USE_ITHREADS
	  case INSN_COP_STASH:		/* 126 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) cop_stash svindex:0x%x, ix:%d\n", insn, arg, ix));
		BSET_cop_stash(cCOP, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_cop_stash(cCOP, arg)\n"));
		break;
	    }
	  case INSN_COP_FILEGV:		/* 127 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) cop_filegv svindex:0x%x, ix:%d\n", insn, arg, ix));
		BSET_cop_filegv(cCOP, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_cop_filegv(cCOP, arg)\n"));
		break;
	    }
#endif
	  case INSN_COP_SEQ:		/* 128 */
	    {
		U32 arg;
		BGET_U32(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) cop_seq U32:%d\n", insn, arg));
		cCOP->cop_seq = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   cCOP->cop_seq = arg;\n"));
		break;
	    }
	  case INSN_COP_ARYBASE:		/* 129 */
	    {
		I32 arg;
		BGET_I32(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) cop_arybase I32:%d\n", insn, arg));
		cCOP->cop_arybase = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   cCOP->cop_arybase = arg;\n"));
		break;
	    }
	  case INSN_COP_LINE:		/* 130 */
	    {
		line_t arg;
		BGET_U32(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) cop_line line_t:%d\n", insn, arg));
		cCOP->cop_line = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   cCOP->cop_line = arg;\n"));
		break;
	    }
	  case INSN_COP_IO:		/* 131 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) cop_io svindex:0x%x, ix:%d\n", insn, arg, ix));
		cCOP->cop_io = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   cCOP->cop_io = arg;\n"));
		break;
	    }
	  case INSN_COP_WARNINGS:		/* 132 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) cop_warnings svindex:0x%x, ix:%d\n", insn, arg, ix));
		BSET_cop_warnings(cCOP, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_cop_warnings(cCOP, arg)\n"));
		break;
	    }
	  case INSN_MAIN_START:		/* 133 */
	    {
		opindex arg;
		BGET_opindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) main_start opindex:0x%x, ix:%d\n", insn, arg, ix));
		PL_main_start = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   PL_main_start = arg;\n"));
		break;
	    }
	  case INSN_MAIN_ROOT:		/* 134 */
	    {
		opindex arg;
		BGET_opindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) main_root opindex:0x%x, ix:%d\n", insn, arg, ix));
		PL_main_root = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   PL_main_root = arg;\n"));
		break;
	    }
	  case INSN_MAIN_CV:		/* 135 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) main_cv svindex:0x%x, ix:%d\n", insn, arg, ix));
		*(SV**)&PL_main_cv = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   *(SV**)&PL_main_cv = arg;\n"));
		break;
	    }
	  case INSN_CURPAD:		/* 136 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) curpad svindex:0x%x, ix:%d\n", insn, arg, ix));
		BSET_curpad(PL_curpad, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_curpad(PL_curpad, arg)\n"));
		break;
	    }
	  case INSN_PUSH_BEGIN:		/* 137 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) push_begin svindex:0x%x, ix:%d\n", insn, arg, ix));
		BSET_push_begin(PL_beginav, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_push_begin(PL_beginav, arg)\n"));
		break;
	    }
	  case INSN_PUSH_INIT:		/* 138 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) push_init svindex:0x%x, ix:%d\n", insn, arg, ix));
		BSET_push_init(PL_initav, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_push_init(PL_initav, arg)\n"));
		break;
	    }
	  case INSN_PUSH_END:		/* 139 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) push_end svindex:0x%x, ix:%d\n", insn, arg, ix));
		BSET_push_end(PL_endav, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_push_end(PL_endav, arg)\n"));
		break;
	    }
	  case INSN_CURSTASH:		/* 140 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) curstash svindex:0x%x, ix:%d\n", insn, arg, ix));
		*(SV**)&PL_curstash = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   *(SV**)&PL_curstash = arg;\n"));
		break;
	    }
	  case INSN_DEFSTASH:		/* 141 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) defstash svindex:0x%x, ix:%d\n", insn, arg, ix));
		*(SV**)&PL_defstash = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   *(SV**)&PL_defstash = arg;\n"));
		break;
	    }
	  case INSN_DATA:		/* 142 */
	    {
		U8 arg;
		BGET_U8(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) data U8:%d\n", insn, arg));
		BSET_data(none, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_data(none, arg)\n"));
		break;
	    }
	  case INSN_INCAV:		/* 143 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) incav svindex:0x%x, ix:%d\n", insn, arg, ix));
		*(SV**)&GvAV(PL_incgv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   *(SV**)&GvAV(PL_incgv) = arg;\n"));
		break;
	    }
	  case INSN_LOAD_GLOB:		/* 144 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) load_glob svindex:0x%x, ix:%d\n", insn, arg, ix));
		BSET_load_glob(none, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_load_glob(none, arg)\n"));
		break;
	    }
#ifdef USE_ITHREADS
	  case INSN_REGEX_PADAV:		/* 145 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) regex_padav svindex:0x%x, ix:%d\n", insn, arg, ix));
		*(SV**)&PL_regex_padav = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   *(SV**)&PL_regex_padav = arg;\n"));
		break;
	    }
#endif
	  case INSN_DOWARN:		/* 146 */
	    {
		U8 arg;
		BGET_U8(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) dowarn U8:%d\n", insn, arg));
		PL_dowarn = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   PL_dowarn = arg;\n"));
		break;
	    }
	  case INSN_COMPPAD_NAME:		/* 147 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) comppad_name svindex:0x%x, ix:%d\n", insn, arg, ix));
		*(SV**)&PL_comppad_name = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   *(SV**)&PL_comppad_name = arg;\n"));
		break;
	    }
	  case INSN_XGV_STASH:		/* 148 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) xgv_stash svindex:0x%x, ix:%d\n", insn, arg, ix));
		*(SV**)&GvSTASH(bstate->bs_sv) = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   *(SV**)&GvSTASH(bstate->bs_sv) = arg;\n"));
		break;
	    }
	  case INSN_SIGNAL:		/* 149 */
	    {
		strconst arg;
		BGET_strconst(arg, 0);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) signal strconst:\"%s\"\n", insn, arg));
		BSET_signal(bstate->bs_sv, arg);
		DEBUG_v(Perl_deb(aTHX_ "	   BSET_signal(bstate->bs_sv, arg)\n"));
		break;
	    }
	  case INSN_FORMFEED:		/* 150 */
	    {
		svindex arg;
		BGET_svindex(arg);
		DEBUG_v(Perl_deb(aTHX_ "(insn %3d) formfeed svindex:0x%x, ix:%d\n", insn, arg, ix));
		PL_formfeed = arg;
		DEBUG_v(Perl_deb(aTHX_ "	   PL_formfeed = arg;\n"));
		break;
	    }
	    default:
	      Perl_croak(aTHX_ "Illegal bytecode instruction %d. Version incompatibility.\n", insn);
	      /* NOTREACHED */
	  }
#ifdef DEBUG_t_TEST_
          if (PL_op && DEBUG_t_TEST_) debop(PL_op);
#endif
        }
    }
    return 0;
}

/* ex: set ro: */
