use utf8;

package SemanticWeb::Schema::BorrowAction;

# ABSTRACT: The act of obtaining an object under an agreement to return it at a later date

use v5.14;
use Moo;

extends qw/ SemanticWeb::Schema::TransferAction /;


use MooX::JSON_LD 'BorrowAction';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v21.0.1';


has lender => (
    is        => 'rw',
    predicate => '_has_lender',
    json_ld   => 'lender',
);





1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::BorrowAction - The act of obtaining an object under an agreement to return it at a later date

=head1 VERSION

version v21.0.1

=head1 DESCRIPTION

The act of obtaining an object under an agreement to return it at a later date. Reciprocal of LendAction.

Related actions:

=over

=item *

L<SemanticWeb::Schema::LendAction>: Reciprocal of BorrowAction.

=back

=head1 ATTRIBUTES

=head2 C<lender>

A sub property of participant. The person that lends the object being
borrowed.

A lender should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::Organization']>

=item C<InstanceOf['SemanticWeb::Schema::Person']>

=back

=head2 C<_has_lender>

A predicate for the L</lender> attribute.

=head1 SEE ALSO

L<SemanticWeb::Schema::TransferAction>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2023 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
