use utf8;

package SemanticWeb::Schema::Protein;

# ABSTRACT: Protein is here used in its widest possible definition

use Moo;

extends qw/ SemanticWeb::Schema::BioChemEntity /;


use MooX::JSON_LD 'Protein';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v13.0.0';


has has_bio_polymer_sequence => (
    is        => 'rw',
    predicate => '_has_has_bio_polymer_sequence',
    json_ld   => 'hasBioPolymerSequence',
);





1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::Protein - Protein is here used in its widest possible definition

=head1 VERSION

version v13.0.0

=head1 DESCRIPTION

Protein is here used in its widest possible definition, as classes of amino
acid based molecules. Amyloid-beta Protein in human (UniProt P05067),
eukaryota (e.g. an OrthoDB group) or even a single molecule that one can
point to are all of type schema:Protein. A protein can thus be a subclass
of another protein, e.g. schema:Protein as a UniProt record can have
multiple isoforms inside it which would also be schema:Protein. They can be
imagined, synthetic, hypothetical or naturally occurring.

=head1 ATTRIBUTES

=head2 C<has_bio_polymer_sequence>

C<hasBioPolymerSequence>

A symbolic representation of a BioChemEnity. For example, a nucleotide
sequence of a Gene or an amino acid sequence of a Protein.

A has_bio_polymer_sequence should be one of the following types:

=over

=item C<Str>

=back

=head2 C<_has_has_bio_polymer_sequence>

A predicate for the L</has_bio_polymer_sequence> attribute.

=head1 SEE ALSO

L<SemanticWeb::Schema::BioChemEntity>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2021 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
