use utf8;

package SemanticWeb::Schema::StatisticalPopulation;

# ABSTRACT: A StatisticalPopulation is a set of instances of a certain given type that satisfy some set of constraints

use Moo;

extends qw/ SemanticWeb::Schema::Intangible /;


use MooX::JSON_LD 'StatisticalPopulation';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v11.01.0';


has constraining_property => (
    is        => 'rw',
    predicate => '_has_constraining_property',
    json_ld   => 'constrainingProperty',
);



has num_constraints => (
    is        => 'rw',
    predicate => '_has_num_constraints',
    json_ld   => 'numConstraints',
);



has population_type => (
    is        => 'rw',
    predicate => '_has_population_type',
    json_ld   => 'populationType',
);





1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::StatisticalPopulation - A StatisticalPopulation is a set of instances of a certain given type that satisfy some set of constraints

=head1 VERSION

version v11.01.0

=head1 DESCRIPTION

A StatisticalPopulation is a set of instances of a certain given type that satisfy some set of constraints. The property [[populationType]] is used to specify the type. Any property that can be used on instances of that type can appear on the statistical population. For example, a L<SemanticWeb::Schema::StatisticalPopulation> representing all L<SemanticWeb::Schema::Person>s with a [[homeLocation]] of East Podunk California, would be described by applying the appropriate [[homeLocation]] and [[populationType]] properties to a L<SemanticWeb::Schema::StatisticalPopulation> item that stands for that set of people.
The properties [[numConstraints]] and [[constrainingProperties]] are used to specify which of the populations properties are used to specify the population. Note that the sense of "population" used here is the general sense of a statistical
population, and does not imply that the population consists of people. For example, a [[populationType]] of L<SemanticWeb::Schema::Event> or L<SemanticWeb::Schema::NewsArticle> could be used. See also L<SemanticWeb::Schema::Observation>, and the L<data and datasets|/docs/data-and-datasets.html> overview for more details.

=head1 ATTRIBUTES

=head2 C<constraining_property>

C<constrainingProperty>

Indicates a property used as a constraint to define a L<SemanticWeb::Schema::StatisticalPopulation> with respect to the set of entities
  corresponding to an indicated type (via [[populationType]]).

A constraining_property should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::Integer']>

=back

=head2 C<_has_constraining_property>

A predicate for the L</constraining_property> attribute.

=head2 C<num_constraints>

C<numConstraints>

Indicates the number of constraints (not counting [[populationType]]) defined for a particular L<SemanticWeb::Schema::StatisticalPopulation>. This helps applications understand if they have access to a sufficiently complete description of a L<SemanticWeb::Schema::StatisticalPopulation>.

A num_constraints should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::Integer']>

=back

=head2 C<_has_num_constraints>

A predicate for the L</num_constraints> attribute.

=head2 C<population_type>

C<populationType>

Indicates the populationType common to all members of a L<SemanticWeb::Schema::StatisticalPopulation>.

A population_type should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::Class']>

=back

=head2 C<_has_population_type>

A predicate for the L</population_type> attribute.

=head1 SEE ALSO

L<SemanticWeb::Schema::Intangible>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2020 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
