package SemanticWeb::Schema::Report;

# ABSTRACT: A Report generated by governmental or non-governmental organization.

use Moo;

extends qw/ SemanticWeb::Schema::Article /;


use MooX::JSON_LD 'Report';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v0.0.1';


has report_number => (
    is        => 'rw',
    predicate => 1,
    json_ld   => 'reportNumber',
);





1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::Report - A Report generated by governmental or non-governmental organization.

=head1 VERSION

version v0.0.1

=head1 DESCRIPTION

A Report generated by governmental or non-governmental organization.

=head1 ATTRIBUTES

=head2 C<report_number>

C<reportNumber>

The number or other unique designator assigned to a Report by the
publishing organization.

A report_number should be one of the following types:

=over

=item C<Str>

=back

=head1 SEE ALSO

L<SemanticWeb::Schema::Article>

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
