# NOTE: Derived from blib/lib/List/MoreUtil.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package List::MoreUtil;

#line 495 "blib/lib/List/MoreUtil.pm (autosplit into blib/lib/auto/List/MoreUtil/each_arrayref.al)"
#--->     $array_iterator = each_arrayref(\@a, \@b, \@c, ...);
#
# Change History:
#     11/30/2001  EJR  First version, from each_array
#     05/30/2002  EJR  Added 'index', 'exhausted', 'nextval' methods.
#                      No longer returns index value in scalar context.
#     10/11/2004  EJR  Removed 'exhausted' and 'nextval' methods; weren't useful.
sub each_arrayref
{
    my @arr_list  = @_;     # The list of references to the arrays
    my $index     = 0;      # Which one the caller will get next
    my $max_num   = 0;      # Number of elements in longest array

    # Get the length of the longest input array
    foreach (@arr_list)
    {
        unless (ref($_) eq 'ARRAY')
        {
            require Carp;
            Carp::croak "each_arrayref: argument is not an array reference\n";
        }
        $max_num = @$_  if @$_ > $max_num;
    }

    # Return the iterator as a closure wrt the above variables.
    return sub
    {
        if (@_)
        {
            my $method = shift;
            if ($method eq 'index')
            {
                # Return current (last fetched) index
                return undef if $index == 0  ||  $index > $max_num;
                return $index-1;
            }
            else
            {
                require Carp;
                Carp::croak "each_array: unknown argument '$method' passed to iterator.";
            }
        }

        return if $index >= $max_num;     # No more elements to return
        my $i = $index++;
        return map $_->[$i], @arr_list;   # Return ith elements
    }
}

# end of List::MoreUtil::each_arrayref
1;
