/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl.handler;

import java.io.IOException;
import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import org.jmx4perl.JmxRequest;
import org.jmx4perl.config.Restrictor;
import org.jmx4perl.converter.StringToObjectConverter;
import org.jmx4perl.handler.JsonRequestHandler;

public class ExecHandler
extends JsonRequestHandler {
    private StringToObjectConverter stringToObjectConverter;

    public ExecHandler(Restrictor pRestrictor, StringToObjectConverter pStringToObjectConverter) {
        super(pRestrictor);
        this.stringToObjectConverter = pStringToObjectConverter;
    }

    public JmxRequest.Type getType() {
        return JmxRequest.Type.EXEC;
    }

    public Object doHandleRequest(MBeanServerConnection server, JmxRequest request) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IOException {
        int i;
        if (!this.restrictor.isOperationAllowed(request.getObjectName(), request.getOperation())) {
            throw new SecurityException("Operation " + request.getOperation() + " forbidden for MBean " + request.getObjectNameAsString());
        }
        String[] paramClazzes = this.extractOperationTypes(server, request);
        Object[] params = new Object[paramClazzes.length];
        List<String> args = request.getExtraArgs();
        if (args.size() != paramClazzes.length) {
            throw new IllegalArgumentException("Invalid operation parameters. Operation " + request.getOperation() + " on " + request.getObjectName() + " requires " + paramClazzes.length + " parameters, not " + args.size() + " as given");
        }
        for (i = 0; i < paramClazzes.length; ++i) {
            params[i] = this.stringToObjectConverter.convertFromString(paramClazzes[i], args.get(i));
        }
        for (i = 0; i < paramClazzes.length; ++i) {
            args.remove(0);
        }
        return server.invoke(request.getObjectName(), request.getOperation(), params, paramClazzes);
    }

    private String[] extractOperationTypes(MBeanServerConnection pServer, JmxRequest pRequest) throws ReflectionException, InstanceNotFoundException, IOException {
        try {
            MBeanInfo mBeanInfo = pServer.getMBeanInfo(pRequest.getObjectName());
            for (MBeanOperationInfo opInfo : mBeanInfo.getOperations()) {
                if (!opInfo.getName().equals(pRequest.getOperation())) continue;
                MBeanParameterInfo[] pInfos = opInfo.getSignature();
                String[] types = new String[pInfos.length];
                for (int i = 0; i < pInfos.length; ++i) {
                    types[i] = pInfos[i].getType();
                }
                return types;
            }
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException("Cannot extract MBeanInfo for " + pRequest.getObjectNameAsString());
        }
        throw new IllegalArgumentException("No operation " + pRequest.getOperation() + " on MBean " + pRequest.getObjectNameAsString() + " exists.");
    }
}

