use strict;
use warnings;
use Test::More tests => 51;
use constant EPS => 1e-2;

# example data and output from
# http://www.itl.nist.gov/div898/handbook/eda/section3/eda35c.htm
# and
# http://www.itl.nist.gov/div898/handbook/eda/section4/eda4251.htm

BEGIN { use_ok('Statistics::Autocorrelation') };

my $acorr = Statistics::Autocorrelation->new();

my @data = (-213,-564,-35,-15,141,115,-420,-360,203,-338,-431,194,-220,-513,154,-125,-559,92,-21,-579,-52,99,-543,-175,162,-457,-346,204,-300,-474,164,-107,-572,-8,83,-541,-224,180,-420,-374,201,-236,-531,83,27,-564,-112,131,-507,-254,199,-311,-495,143,-46,-579,-90,136,-472,-338,202,-287,-477,169,-124,-568,17,48,-568,-135,162,-430,-422,172,-74,-577,-13,92,-534,-243,194,-355,-465,156,-81,-578,-64,139,-449,-384,193,-198,-538,110,-44,-577,-6,66,-552,-164,161,-460,-344,205,-281,-504,134,-28,-576,-118,156,-437,-381,200,-220,-540,83,11,-568,-160,172,-414,-408,188,-125,-572,-32,139,-492,-321,205,-262,-504,142,-83,-574,0,48,-571,-106,137,-501,-266,190,-391,-406,194,-186,-553,83,-13,-577,-49,103,-515,-280,201,300,-506,131,-45,-578,-80,138,-462,-361,201,-211,-554,32,74,-533,-235,187,-372,-442,182,-147,-566,25,68,-535,-244,194,-351,-463,174,-125,-570,15,72,-550,-190,172,-424,-385,198,-218,-536,96);

my @coeffs = (1.00,-0.31,-0.74,0.77,0.21,-0.90,0.38,0.63,-0.77,-0.12,0.82,-0.40,-0.55,0.73,0.07,-0.76,0.40,0.48,-0.70,-0.03,0.70,-0.41,-0.43,0.67,0.00,-0.66,0.42,0.39,-0.65,0.03,0.63,-0.42,-0.36,0.64,-0.05,-0.60,0.43,0.32,-0.64,0.08,0.58,-0.45,-0.28,0.62,-0.10,-0.55,0.45,0.25,-0.61,0.14);

my $coeff;

foreach my $k(0 .. 49) {

    $coeff = $acorr->coefficient(data => \@data, lag => $k, exact => 0, unbias => 0, circular => 0);
    ok( about_equal($coeff, $coeffs[$k]), "Coefficient lag $k: $coeff = $coeffs[$k]");

}

sub about_equal {
    return 0 if ! defined $_[0] || ! defined $_[1];
    return 1 if $_[0] + EPS > $_[1] and $_[0] - EPS < $_[1];
    return 0;
}
1;
