# 3B-calcstats_pair.t version 0.01
# A script to run tests on the Lingua::Norms::USF module.
# Checks correct returns of data from statistics calculated from available data
use strict;
use warnings;

use Test::More tests => 13;
use constant EPS => 1e-9;

BEGIN { use_ok('Lingua::Norms::USF') };

my $usf = Lingua::Norms::USF->new();

my ($word1, $word2, $dat) = (qw/MILK COW/);

my %dat_ref = (
    NSG => 0.74,
    MCX => 1,
    OCX => 0,
    ASD => 1,
    levd_w => 4,
    mui_w => 0.25
);

# Get stats by method name:
$dat = $usf->net_strength($word1, $word2);
ok( is_equal($dat, $dat_ref{'NSG'}), "nsg calculated = $dat, should be $dat_ref{'NSG'}" );

$dat = $usf->mediator_count_x($word1, $word2);
ok( is_equal($dat, $dat_ref{'MCX'}), "mcx calculated = $dat, should be $dat_ref{'MCX'}" );

$dat = $usf->overlap_count_x($word1, $word2);
ok( is_equal($dat, $dat_ref{'OCX'}), "ocx calculated = $dat, should be $dat_ref{'OCX'}" );

$dat = $usf->assoc_depth($word1, $word2);
ok( is_equal($dat, $dat_ref{'ASD'}), "rel calculated = $dat, should be $dat_ref{'ASD'}" );

# test if are_orthons by orthon_level
$dat = $usf->orthon_level($word1, 'MINK');
ok( is_equal($dat, 1), "orthons? expected = 1, observed $dat" );

$dat = $usf->orthon_level($word1, 'THIN');
ok( is_equal($dat, 0), "orthons? expected = 0, observed $dat" );

# test same method but request Lev-dist:
$dat = $usf->orthon_level($word1, 'THIN', stat => 'levd');
ok( is_equal($dat, $dat_ref{'levd_w'}), "orthons? expected = $dat_ref{'levd_w'}, observed $dat" );

# test same method but request Myers-Ukkonen index:
$dat = $usf->orthon_level($word1, 'THIN', stat => 'mui');
ok( is_equal($dat, $dat_ref{'mui_w'}), "orthons? expected = $dat_ref{'mui_w'}, observed $dat" );

# Get stats directly from word_stat();
foreach my $s(qw/NSG MCX OCX ASD/) {
    $dat = $usf->assoc_stat($word1, $word2, $s, {cues_only => 0});
    ok( is_equal($dat, $dat_ref{$s}), "$s calculated = $dat, should be $dat_ref{$s}" );
}

sub is_equal {
    return 1 if $_[0] == $_[1];
    return 0;
}

sub char_equal {
    return 1 if $_[0] eq $_[1];
    return 0;
}

sub about_equal {
    return 1 if $_[0] + EPS > $_[1] and $_[0] - EPS < $_[1];
    return 0;
}
