use strict;
use warnings;
use Test::More;

# Ensure a recent version of Test::Pod::Coverage
my $min_tpc = 1.08;
eval "use Test::Pod::Coverage $min_tpc";
plan skip_all => "Test::Pod::Coverage $min_tpc required for testing POD coverage"
    if $@;

# Test::Pod::Coverage doesn't require a minimum Pod::Coverage version,
# but older versions don't recognize some common documentation styles
my $min_pc = 0.18;
eval "use Pod::Coverage $min_pc";
plan skip_all => "Pod::Coverage $min_pc required for testing POD coverage"
    if $@;

all_pod_coverage_ok({trustme => [qw/act are_associated are_orthons are_related assoc_count associates associated bsg ccn cct cnm csz cues find_by_pattern frq fsg hmg is_cue is_listed loop_thru mct mcx mediators msg nsg oct ocx onc onl osg overlaps psp random_data related rsm rss sct set_size shared_count ssz tsg/]});
