#===============================================================================
#      PODNAME:  Net::IP::Identifier::Plugin::Eonix
#     ABSTRACT:  identify Eonix (AS30693) owned IP addresses
#
#       AUTHOR:  Reid Augustin (REID)
#        EMAIL:  reid@hellosix.com
#      CREATED:  Sun Oct 12 19:32:46 PDT 2014
#===============================================================================

use 5.008;
use strict;
use warnings;

package Net::IP::Identifier::Plugin::Eonix;

use Role::Tiny::With;
with qw( Net::IP::Identifier_Role );

our $VERSION = '0.086'; # VERSION

sub new {
    my ($class, %opts) = @_;

    my $self = {};
    bless $self, (ref $class || $class);

    # List of known Eonix (AS30693) IP blocks as of Oct 2014
    $self->ips(qw(
        23.90.0.0 - 23.90.63.255
        23.231.0.0 - 23.231.127.255
        50.2.0.0 - 50.3.255.255
        75.75.224.0 - 75.75.255.255
        104.140.0.0 - 104.140.255.255
        104.206.0.0 - 104.206.255.255
        107.158.0.0 - 107.158.255.255
        170.130.0.0 - 170.130.255.255
        173.44.128.0 - 173.44.255.255
        173.213.64.0 - 173.213.127.255
        173.232.0.0 - 173.232.255.255
        206.214.64.0 - 206.214.95.255
        208.89.216.0 - 208.89.223.255
    ));
    return $self;
}

sub name {
    return 'Eonix';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::IP::Identifier::Plugin::Eonix - identify Eonix (AS30693) owned IP addresses

=head1 VERSION

version 0.086

=head1 SYNOPSIS

 use Net::IP::Identifier::Plugin::Eonix;

=head1 DESCRIPTION

Net::IP::Identifier::Plugin::Eonix identifies Eonix (AS30693) host IPs.

=head2 Methods

=over

=item new

Creates a new Net::IP::Identifier::Plugin::Eonix object.

=back

=head1 SEE ALSO

=over

=item IP::Net

=item IP::Net::Identifier

=item IP::Net::Identifier_Role

=back

=head1 AUTHOR

Reid Augustin <reid@hellosix.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Reid Augustin.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
