#===============================================================================
#      PODNAME:  Net::IP::Identifier::Plugin::Comcast
#     ABSTRACT:  identify Comcast owned IP addresses
#
#       AUTHOR:  Reid Augustin (REID)
#        EMAIL:  reid@hellosix.com
#      CREATED:  Thu Nov  6 11:03:17 PST 2014
#===============================================================================

use 5.008;
use strict;
use warnings;

package Net::IP::Identifier::Plugin::Comcast;

use Role::Tiny::With;
with qw( Net::IP::Identifier_Role );

our $VERSION = '0.086'; # VERSION

sub new {
    my ($class, %opts) = @_;

    my $self = {};
    bless $self, (ref $class || $class);

    # List of known Comcast IP blocks as of Nov 2014
    $self->ips(qw(
        12.41.68.0 - 12.41.71.255
        12.109.232.0 - 12.109.235.255
        23.24.0.0 - 23.25.255.255
        23.30.0.0 - 23.31.255.255
        23.68.0.0 - 23.71.255.255
        24.0.0.0 - 24.15.255.255
        24.16.0.0 - 24.23.255.255
        24.30.0.0 - 24.30.95.255
        24.30.96.0 - 24.30.127.255
        24.34.0.0 - 24.34.255.255
        24.40.0.0 - 24.40.79.255
        24.60.0.0 - 24.63.255.255
        24.91.0.0 - 24.91.255.255
        24.98.0.0 - 24.99.255.255
        24.104.0.0 - 24.104.159.255
        24.118.0.0 - 24.118.255.255
        24.124.128.0 - 24.124.255.255
        24.125.0.0 - 24.125.255.255
        24.126.0.0 - 24.127.255.255
        24.128.0.0 - 24.128.255.255
        24.129.0.0 - 24.129.127.255
        24.130.0.0 - 24.131.255.255
        24.147.0.0 - 24.147.255.255
        24.149.128.0 - 24.149.255.255
        24.153.64.0 - 24.153.95.255
        24.218.0.0 - 24.218.255.255
        24.245.0.0 - 24.245.63.255
        50.73.0.0 - 50.73.255.255
        50.76.0.0 - 50.79.255.255
        50.128.0.0 - 50.255.255.255
        64.56.32.0 - 64.56.63.255
        64.78.64.0 - 64.78.127.255
        64.139.64.0 - 64.139.95.255
        64.235.160.0 - 64.235.191.255
        65.34.128.0 - 65.34.255.255
        65.96.0.0 - 65.97.31.255
        66.30.0.0 - 66.31.255.255
        66.41.0.0 - 66.41.255.255
        66.56.0.0 - 66.56.63.255
        66.176.0.0 - 66.177.255.255
        66.208.192.0 - 66.208.255.255
        66.229.0.0 - 66.229.255.255
        66.240.0.0 - 66.240.63.255
        67.160.0.0 - 67.191.255.255
        68.32.0.0 - 68.63.255.255
        68.80.0.0 - 68.87.255.255
        69.136.0.0 - 69.143.255.255
        69.180.0.0 - 69.181.255.255
        69.240.0.0 - 69.255.255.255
        70.88.0.0 - 70.91.255.255
        71.24.0.0 - 71.27.255.255
        71.56.0.0 - 71.63.255.255
        71.192.0.0 - 71.207.255.255
        71.224.0.0 - 71.239.255.255
        72.55.0.0 - 72.55.127.255
        73.0.0.0 - 73.255.255.255
        74.16.0.0 - 74.31.255.255
        74.81.128.0 - 74.81.159.255
        74.92.0.0 - 74.95.255.255
        74.144.0.0 - 74.159.255.255
        75.64.0.0 - 75.75.191.255
        75.144.0.0 - 75.151.255.255
        76.16.0.0 - 76.31.255.255
        76.96.0.0 - 76.127.255.255
        76.128.0.0 - 76.159.255.255
        96.64.0.0 - 96.124.255.255
        96.128.0.0 - 96.191.255.255
        96.192.0.0 - 96.223.255.255
        98.32.0.0 - 98.63.255.255
        98.192.0.0 - 98.255.255.255
        107.0.0.0 - 107.5.255.255
        108.171.224.0 - 108.171.239.255
        147.191.0.0 - 147.191.255.255
        162.17.0.0 - 162.17.255.255
        162.148.0.0 - 162.151.255.255
        165.137.0.0 - 165.137.255.255
        169.152.0.0 - 169.152.255.255
        172.244.0.0 - 172.244.255.255
        173.8.0.0 - 173.15.255.255
        173.160.0.0 - 173.167.255.255
        174.48.0.0 - 174.63.255.255
        174.160.0.0 - 174.191.255.255
        184.108.0.0 - 184.127.255.255
        198.0.0.0 - 198.0.255.255
        198.137.252.0 - 198.137.253.255
        198.178.8.0 - 198.178.15.255
        199.182.100.0 - 199.182.103.255
        206.18.184.0 - 206.18.184.255
        207.223.0.0 - 207.223.15.255
        208.39.128.0 - 208.39.191.255
        208.110.192.0 - 208.110.223.255
        209.23.192.0 - 209.23.255.255
        216.45.128.0 - 216.45.255.255
        2001:558:: - 2001:559:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:55A:: - 2001:55F:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF
        2601:: - 2601:FFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF
        2604:6A00:: - 2604:6A00:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF
        2620:FD:8000:: - 2620:FD:8000:FFFF:FFFF:FFFF:FFFF:FFFF
    ));
    return $self;
}

sub name {
    return 'Comcast';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::IP::Identifier::Plugin::Comcast - identify Comcast owned IP addresses

=head1 VERSION

version 0.086

=head1 SYNOPSIS

 use Net::IP::Identifier::Plugin::Comcast;

=head1 DESCRIPTION

Net::IP::Identifier::Plugin::Comcast identifies Comcast host IPs.

=head2 Methods

=over

=item new

Creates a new Net::IP::Identifier::Plugin::Comcast object.

=back

=head1 SEE ALSO

=over

=item IP::Net

=item IP::Net::Identifier

=item IP::Net::Identifier_Role

=back

=head1 AUTHOR

Reid Augustin <reid@hellosix.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Reid Augustin.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
