#!/usr/bin/perl
#
#	Rich's Hyper Text tools that get used in every daggone
#  Web perl script one ever writes.
#  Richard Bowen
#  Begun 12/4/95
#
#
#	Contents:
#   header - prints content type header for HTML
#   title - Prints title for html page.  Usage - &title('Desired title');
#   form_parse - parses form, sticks it into $FORM{'variable_name'}
#   AIC_footer - prints html footer for AIC documents
#   footer - prints generic end of html page
#   date - returns todays date in nicer format
#   julean - returns julean date with jan 1, 1995 as day 1
#   todayjulean - returns today's julean date.  Calls julean
#
#


#  Header:  Prints html header to browser, telling it that
#  This is a html document, even though it really is not.
#
sub header
{
print "content-type: text/html \n\n";
}

#  Title:  Prints generic top of html document - nothing fancy 
#  yet, just <html><head><title>Parameter</title></head><body>.

sub title  {
	local($parameter) = @_;
	print "\n<html><head><title>$parameter</title></head><body> \n\n";
	   }

#  form_parse:  Reads in the form information from a post and
#  parses it out into $FORM{'variable_name'}
sub form_parse  {
	# Get the input 
	read (STDIN, $buffer, $ENV{'CONTENT_LENGTH'});

	# Split the name-value pairs
	@pairs = split(/&/, $buffer);

	foreach $pair (@pairs)
	{
    	($name, $value) = split(/=/, $pair);

    	# Un-Webify plus signs and %-encoding
    	$value =~ tr/+/ /;
    	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

    	# Stop people from using subshells to execute commands
    	# Not a big deal when using sendmail, but very important
    	# when using UCB mail (aka mailx).
    	# $value =~ s/~!/ ~!/g;

    	# Uncomment for debugging purposes
    	# print "Setting $name to $value<P>";

    	$FORM{$name} = $value;
	}     # End of foreach
	}	#  End of sub

#  AIC_footer
#  This prints out the aic logo and generic footer.
#  This MUST be removed if you ever decide to distribut this script in 
#  ANY form whatsoever.

sub AIC_footer  {
	print "\n\n<hr>\n";
	print "<img alt=\"\" align=left src=\"/images/aic_tiny.gif\" > \n";
	print "<a href=\"/index.html\">AiC</a>, Lexington.<br> \n";
	print "Please send questions, comments, or suggestions to <a href=\"/cgi-bin/mail.pl?webmaster\">the Webmaster</a>.<hr></html> \n";
	}

#	Date - returns the date and time, hopefully

sub date	{
	$date=localtime(time);
	($day, $month, $no, $hr, $year) = split (/\s+/,$date);
	$return_date = "$hr, $month $no";
		}

sub todayjulean	{

	$date=localtime(time);
	@date=split (/\s+/, $date);
	$mon=@date[1];
	if ($mon=~/jan/i){$mon="1"}
	elsif ($mon=~/feb/i){$mon="2"}
	elsif ($mon=~/mar/i){$mon="3"}
	elsif ($mon=~/apr/i){$mon="4"}
	elsif ($mon=~/may/i){$mon="5"}
	elsif ($mon=~/jun/i){$mon="6"}
	elsif ($mon=~/jul/i){$mon="7"}
	elsif ($mon=~/aug/i){$mon="8"}
	elsif ($mon=~/sep/i){$mon="9"}
	elsif ($mon=~/oct/i){$mon="10"}
	elsif ($mon=~/nov/i){$mon="11"}
	elsif ($mon=~/dec/i){$mon="12"};
	&julean ($mon, @date[2], @date[4]);
	$today = $jule;
		}

sub footer {print "</body></html>";}

sub redirect {
($_)=@_;
print"Location: $_ \n\n"; }

sub month_txt   {
($_)=@_;
if ($_==1) {$month_txt = "January"}
elsif ($_==2) {$month_txt="February"}
elsif ($_==3) {$month_txt="March"}
elsif ($_==4) {$month_txt="April"}
elsif ($_==5) {$month_txt="May"}
elsif ($_==6) {$month_txt="June"}
elsif ($_==7) {$month_txt="July"}
elsif ($_==8) {$month_txt="August"}
elsif ($_==9) {$month_txt="September"}
elsif ($_==10) {$month_txt="October"}
elsif ($_==11) {$month_txt="November"}
elsif ($_==12) {$month_txt="December"}
else {$month_txt="ERROR"};
                }

sub julean{ 
#
# Julean date based on Jan. 1, 1992 being day 1.
# Takes date in Month, day, and year order and finds julean date.
# Outputs julean number for inputted date.
#
#	This sub written by David Moose Pitts and modified by Rich Bowen
#
#	Usage:   &julean(month, day, year);

$thisdayjulean=0;

@months=(0,31,28,31,30,31,30,31,31,30,31,30,31);

$local_month=$_[0];
$tday=$_[1];
$tyear=$_[2];
$leapdays=((($tyear-1992)/4)+1);     #must be a leap year, so I chose 1992 

# This section drops the remainder of the leap day for the year.
$leapdays2=(($tyear-1992)%4);
$leapdays-=($leapdays2*0.25);
if ($tyear>=2000) {$leapdays-= 1};   #even 100 year years do not have
                                                # leap days in them
$local_thisyear=$tyear-1992;
for ($local_i=1;$local_i<=$local_thisy                                                                                                                                                                                                                                                                                                                                         