package Forms::Langues_dbc;

use strict;
use warnings;
use Data::Dumper;
use base qw(Wx::App);
use Wx::Perl::DbLinker::Wxform;
use Gtk2::Ex::DbLinker::DbcDataManager;
use  Log::Log4perl;

use Wx_dnav;
use Forms::Sflang_dbc;

sub new {
    
    my ( $class, $href ) = @_;
   my $self = $class->SUPER::new();  
   $self->{xrcfolder}=  $$href{xrcfolder};
   $self->{schema} = $$href{schema};
   $self->{log} = Log::Log4perl->get_logger(__PACKAGE__);
   $self->{dnav} = Wx_dnav->new({size=> [900,900], main_name=>'mainwindow', main_file=>'../xrc/main.xrc', schema=> $self->{schema}});
    $self->{dnav}->load_panel('mainwindow', 'xrc/nav.xrc', 'm_dnav_panel' );

    my $path = $self->{xrcfolder} . "\\content.xrc";
    my $top_panel = $self->{dnav}->load_panel('m_panel_for_content', $path, 'm_panel1');

    $self->{log}->debug(" new form ");

    $self->{dnav}->populate_widgets($self->{dnav}->get_object("m_panel_for_buttons"), [qw(b_apply)]);

      my $rs = $self->{schema}->resultset('Country')->search_rs(undef, {order_by => 'country'});

    my $dman =  Gtk2::Ex::DbLinker::DbcDataManager->new({
			rs => $rs,
		
		});


     $self->{linker} = Wx::Perl::DbLinker::Wxform->new({ 
		    data_manager => $dman,
		    builder =>  $self->{dnav},
		    rec_spinner => $self->{dnav}->get_object('RecordSpinner'),
  	    	    status_label=>  $self->{dnav}->get_object('lbl_RecordStatus'),
		    rec_count_label => $self->{dnav}->get_object("lbl_RecordCount"),
		    primary_keys => ["countryid"],	
		    datawidgets_changed =>{countryid => sub{ on_countryid_changed($self->{dnav}->get_object('countryid'), $self);}, },
	    });

   $self->{dnav}->set_form($self->{linker});

  $self->{countryid} = $dman->get_field('countryid');


      my $combodata = Gtk2::Ex::DbLinker::DbcDataManager->new({
		   rs =>  $self->{schema}->resultset('Langue')->search_rs(undef, {sort_by => 'langue'}),
			
		});
       
	$self->{linker}->add_combo({
    		data_manager => $combodata,
	    	id => 'mainlangid',
      });

	$self->{sf} = Forms::Sflang_dbc->new({xrcfolder => $self->{xrcfolder}, 
			schema => $self->{schema} , 
			dnav=>$self->{dnav}, 
			panel_to =>  'panel_subform',
			countryid => $self->{countryid},
		});


	$self->{linker}->add_childform($self->{sf}->{sform});

	$self->{linker}->update;



	 $self->{dnav}->show_all_except([]);
	 
	 $self->{sf}->{dnav}->show_all_except([]);



	 $self->{sf}->{sf_list}->{dnav}->show_all_except([]);

	  return $self;

     }

sub OnInit {
1;
}

sub on_countryid_changed {
	my ($b, $self) =@_;
	$self->{log}->debug("countryid_changed called");
	my $value = $b->GetLineText(0);
	$value = ( $value eq "" ? undef : $value);
	#return && $self->{dnav}->widgets_set_sensitivity(0) unless defined ($value);
	if (defined $value) {
		$self->{log}->debug("on_countryid_changed : $value");
		$self->{countryid} = $value;
		my $rc = $self->{linker}->get_data_manager->row_count;
		if ($rc == 0) {	
			$self->{dnav}->widgets_set_sensitivity(0);
		} else {
			$self->{dnav}->widgets_set_sensitivity(1);
		}
		$self->{sf}->on_countryid_changed($value);
	} else {
		$self->{sf}->on_countryid_changed($value);
		$self->{dnav}->widgets_set_sensitivity(0);
	}
 }





1;
