#!/usr/bin/perl

use strict;
use warnings;

use Net::DRI;
use Net::DRI::Data::Raw;
use DateTime::Duration;

use Test::More tests => 58;
eval { no warnings; require Test::LongString; Test::LongString->import(max => 100); $Test::LongString::Context=50; };
if ( $@ ) { no strict 'refs'; *{'main::is_string'}=\&main::is; }

our $E1='<?xml version="1.0" encoding="UTF-8" standalone="no"?><epp xmlns="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">';
our $E2='</epp>';
our $TRID='<trID><clTRID>ABC-12345</clTRID><svTRID>54322-XYZ</svTRID></trID>';

our ($R1,$R2);
sub mysend { my ($transport,$count,$msg)=@_; $R1=$msg->as_string(); return 1; }
sub myrecv { return Net::DRI::Data::Raw->new_from_string($R2? $R2 : $E1.'<response>'.r().$TRID.'</response>'.$E2); }
sub r      { my ($c,$m)=@_; return '<result code="'.($c || 1000).'"><msg>'.($m || 'Command completed successfully').'</msg></result>'; }

my $dri=Net::DRI::TrapExceptions->new({cache_ttl => 10, trid_factory => sub { return 'ABC-12345'}});
$dri->add_current_registry('VeriSign::COM_NET');
$dri->add_current_profile('p1','epp',{f_send=>\&mysend,f_recv=>\&myrecv},{extensions=>['UnitedTLD::Charge','-VeriSign::NameStore','-VeriSign::IDNLanguage']});

my ($rc,$data);


$R2=$E1.'<response>'.r().'<resData><domain:chkData xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd" xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"><domain:cd><domain:name avail="1">85014aaaa.com</domain:name></domain:cd></domain:chkData></resData><extension><charge:chkData xmlns:charge="http://www.unitedtld.com/epp/charge-1.0"><charge:cd><charge:name>85014aaaa.com</charge:name><charge:set><charge:category name="AAAA">premium</charge:category><charge:type>price</charge:type><charge:amount command="create">20.0000</charge:amount><charge:amount command="renew">20.0000</charge:amount><charge:amount command="transfer">20.0000</charge:amount><charge:amount command="update" name="restore">20.0000</charge:amount></charge:set></charge:cd></charge:chkData></extension>'.$TRID.'</response>'.$E2;
$rc=$dri->domain_check('85014aaaa.com');
$data=$rc->get_data('domain','85014aaaa.com','price');
is_deeply($data->{category},{name => 'AAAA', value => 'premium'},'domain_check 1 response category');
is($data->{type},'price','domain_check 1 response type');
is($data->{create},20,'domain_check 1 response create');
is($data->{renew},20,'domain_check 1 response renew');
is($data->{transfer},20,'domain_check 1 response transfer');
is($data->{'update.restore'},20,'domain_check 1 response update.restore');



$R2=$E1.'<response>'.r().'<resData><domain:chkData xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd" xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"><domain:cd><domain:name avail="1">85014aaaa.com</domain:name></domain:cd><domain:cd><domain:name avail="1">85014bbbb.com</domain:name></domain:cd><domain:cd><domain:name avail="1">85014cccc.com</domain:name></domain:cd></domain:chkData></resData><extension><charge:chkData xmlns:charge="http://www.unitedtld.com/epp/charge-1.0"><charge:cd><charge:name>85014aaaa.com</charge:name><charge:set><charge:category name="AAAA">premium</charge:category><charge:type>price</charge:type><charge:amount command="create">20.0000</charge:amount><charge:amount command="renew">20.0000</charge:amount><charge:amount command="transfer">20.0000</charge:amount><charge:amount command="update" name="restore">20.0000</charge:amount></charge:set></charge:cd><charge:cd><charge:name>85014bbbb.com</charge:name><charge:set><charge:category name="AAAA">premium</charge:category><charge:type>price</charge:type><charge:amount command="create">20.0000</charge:amount><charge:amount command="renew">20.0000</charge:amount><charge:amount command="transfer">20.0000</charge:amount><charge:amount command="update" name="restore">20.0000</charge:amount></charge:set></charge:cd><charge:cd><charge:name>85014cccc.com</charge:name><charge:set><charge:category name="AAAA">premium</charge:category><charge:type>price</charge:type><charge:amount command="create">20.0000</charge:amount><charge:amount command="renew">20.0000</charge:amount><charge:amount command="transfer">20.0000</charge:amount><charge:amount command="update" name="restore">20.0000</charge:amount></charge:set></charge:cd></charge:chkData></extension>'.$TRID.'</response>'.$E2;
$rc=$dri->domain_check(qw/85014aaaa.com 85014.com 85014cccc.com/);
$data=$rc->get_data('domain','85014aaaa.com','price');
is_deeply($data->{category},{name => 'AAAA', value => 'premium'},'domain_check 2 response 1 category');
is($data->{type},'price','domain_check 2 response 1 type');
is($data->{create},20,'domain_check 2 response 1 create');
is($data->{renew},20,'domain_check 2 response 1 renew');
is($data->{transfer},20,'domain_check 2 response 1 transfer');
is($data->{'update.restore'},20,'domain_check 2 response 1 update.restore');
$data=$rc->get_data('domain','85014bbbb.com','price');
is_deeply($data->{category},{name => 'AAAA', value => 'premium'},'domain_check 2 response 2 category');
is($data->{type},'price','domain_check 2 response 2 type');
is($data->{create},20,'domain_check 2 response 2 create');
is($data->{renew},20,'domain_check 2 response 2 renew');
is($data->{transfer},20,'domain_check 2 response 2 transfer');
is($data->{'update.restore'},20,'domain_check 2 response 2 update.restore');
$data=$rc->get_data('domain','85014cccc.com','price');
is_deeply($data->{category},{name => 'AAAA', value => 'premium'},'domain_check 2 response 3 category');
is($data->{type},'price','domain_check 2 response 3 type');
is($data->{create},20,'domain_check 2 response 3 create');
is($data->{renew},20,'domain_check 2 response 3 renew');
is($data->{transfer},20,'domain_check 2 response 3 transfer');
is($data->{'update.restore'},20,'domain_check 2 response 3 update.restore');



$R2=$E1.'<response>'.r().'<resData><domain:creData xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd" xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"><domain:name>85014aaaa.TLD</domain:name><domain:crDate>2013-10-11T20:26:55.893Z</domain:crDate><domain:exDate>2014-10-11T20:26:55.893Z</domain:exDate></domain:creData></resData><extension><charge:creData xmlns:charge="http://www.unitedtld.com/epp/charge-1.0"><charge:set><charge:category name="AAAA">premium</charge:category><charge:type>price</charge:type><charge:amount command="create">20.0000</charge:amount><charge:amount command="renew">20.0000</charge:amount><charge:amount command="transfer">20.0000</charge:amount><charge:amount command="update" name="restore">20.0000</charge:amount></charge:set></charge:creData></extension>'.$TRID.'</response>'.$E2;
my $cs=$dri->local_object('contactset');
my $c1=$dri->local_object('contact')->srid('sh1890');
$cs->set($c1,'registrant');
$cs->set($c1,'admin');
$cs->set($c1,'tech');
my %price=(category => { name => 'AAAA', value => 'premium' },
           type => 'price',
           create => 20,
          );
$rc=$dri->domain_create('85014aaaa.com',{pure_create=>1,duration=>$dri->local_object('duration',years => 1),contact=>$cs,auth=>{pw=>'2foo%BAR'},price=>\%price});
is_string($R1,$E1.'<command><create><domain:create xmlns:domain="urn:ietf:params:xml:ns:domain-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd"><domain:name>85014aaaa.com</domain:name><domain:period unit="y">1</domain:period><domain:registrant>sh1890</domain:registrant><domain:contact type="admin">sh1890</domain:contact><domain:contact type="tech">sh1890</domain:contact><domain:authInfo><domain:pw>2foo%BAR</domain:pw></domain:authInfo></domain:create></create><extension><charge:agreement xmlns:charge="http://www.unitedtld.com/epp/charge-1.0" xsi:schemaLocation="http://www.unitedtld.com/epp/charge-1.0 charge-1.0.xsd"><charge:set><charge:category name="AAAA">premium</charge:category><charge:type>price</charge:type><charge:amount command="create">20</charge:amount></charge:set></charge:agreement></extension><clTRID>ABC-12345</clTRID></command>'.$E2,'domain_create build');
$data=$rc->get_data('domain','85014aaaa.com','price');
is_deeply($data->{category},{name => 'AAAA', value => 'premium'},'domain_create response category');
is($data->{type},'price','domain_create response type');
is($data->{create},20,'domain_create response create');
is($data->{renew},20,'domain_create response renew');
is($data->{transfer},20,'domain_create response transfer');
is($data->{'update.restore'},20,'domain_create response update.restore');



$R2=$E1.'<response>'.r().'<resData><domain:infData xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd" xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"><domain:name>85014aaaa.com</domain:name><domain:roid>23e82a3f0a614691b9e53d3d0156fe05-D</domain:roid><domain:status s="ok"/><domain:registrant>sh1890</domain:registrant><domain:contact type="admin">sh1890</domain:contact><domain:contact type="tech">sh1890</domain:contact><domain:clID>Registrar100</domain:clID><domain:crID>Registrar100</domain:crID><domain:crDate>2013-10-11T20:26:55.893Z</domain:crDate><domain:upID>Registrar100</domain:upID><domain:upDate>2013-10-11T20:26:56.35Z</domain:upDate><domain:exDate>2014-10-11T20:26:55.893Z</domain:exDate><domain:authInfo><domain:pw>2foo%BAR</domain:pw></domain:authInfo></domain:infData></resData><extension><rgp:infData xmlns:rgp="urn:ietf:params:xml:ns:rgp-1.0"><rgp:rgpStatus s="addPeriod" /></rgp:infData><charge:infData xmlns:charge="http://www.unitedtld.com/epp/charge-1.0"><charge:set><charge:category name="AAAA">premium</charge:category><charge:type>price</charge:type><charge:amount command="create">20.0000</charge:amount><charge:amount command="renew">20.0000</charge:amount><charge:amount command="transfer">20.0000</charge:amount><charge:amount command="update" name="restore">20.0000</charge:amount></charge:set></charge:infData></extension>'.$TRID.'</response>'.$E2;
$rc=$dri->domain_info('85014aaaa.com');
$data=$rc->get_data('domain','85014aaaa.com','price');
is_deeply($data->{category},{name => 'AAAA', value => 'premium'},'domain_info response category');
is($data->{type},'price','domain_info response type');
is($data->{create},20,'domain_info response create');
is($data->{renew},20,'domain_info response renew');
is($data->{transfer},20,'domain_info response transfer');
is($data->{'update.restore'},20,'domain_info response update.restore');



$R2=$E1.'<response>'.r().'<resData><domain:renData xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd" xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"><domain:name>85014aaaa.com</domain:name><domain:exDate>2015-10-11T20:26:55.893Z</domain:exDate></domain:renData></resData><extension><charge:renData xmlns:charge="http://www.unitedtld.com/epp/charge-1.0"><charge:set><charge:category name="AAAA">premium</charge:category><charge:type>price</charge:type><charge:amount command="create">20.0000</charge:amount><charge:amount command="renew">20.0000</charge:amount><charge:amount command="transfer">20.0000</charge:amount><charge:amount command="update" name="restore">20.0000</charge:amount></charge:set></charge:renData></extension>'.$TRID.'</response>'.$E2;
%price=(category => { name => 'AAAA', value => 'premium' },
        type => 'price',
        renew => 20,
       );
$rc=$dri->domain_renew('85014aaaa.com',{current_expiration => $dri->local_object('datetime',year=>2014,month=>10,day=>11),duration => $dri->local_object('duration', years => 1), price => \%price});
is_string($R1,$E1.'<command><renew><domain:renew xmlns:domain="urn:ietf:params:xml:ns:domain-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd"><domain:name>85014aaaa.com</domain:name><domain:curExpDate>2014-10-11</domain:curExpDate><domain:period unit="y">1</domain:period></domain:renew></renew><extension><charge:agreement xmlns:charge="http://www.unitedtld.com/epp/charge-1.0" xsi:schemaLocation="http://www.unitedtld.com/epp/charge-1.0 charge-1.0.xsd"><charge:set><charge:category name="AAAA">premium</charge:category><charge:type>price</charge:type><charge:amount command="renew">20</charge:amount></charge:set></charge:agreement></extension><clTRID>ABC-12345</clTRID></command>'.$E2,'domain_renew build');
$data=$rc->get_data('domain','85014aaaa.com','price');
is_deeply($data->{category},{name => 'AAAA', value => 'premium'},'domain_info response category');
is($data->{type},'price','domain_info response type');
is($data->{create},20,'domain_info response create');
is($data->{renew},20,'domain_info response renew');
is($data->{transfer},20,'domain_info response transfer');
is($data->{'update.restore'},20,'domain_info response update.restore');



$R2=$E1.'<response>'.r().'<resData><domain:trnData xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd" xmlns:domain="urn:ietf:params:xml:ns:domain-1.0"><domain:name>85014aaaa.com</domain:name><domain:trStatus>pending</domain:trStatus><domain:reID>Registrar200</domain:reID><domain:reDate>2013-10-11T21:01:20.377Z</domain:reDate><domain:acID>Registrar100</domain:acID><domain:acDate>2013-10-16T21:01:20.377Z</domain:acDate><domain:exDate>2016-10-06T20:26:55.893Z</domain:exDate></domain:trnData></resData><extension><charge:trnData xmlns:charge="http://www.unitedtld.com/epp/charge-1.0"><charge:set><charge:category name="AAAA">premium</charge:category><charge:type>price</charge:type><charge:amount command="create">20.0000</charge:amount><charge:amount command="renew">20.0000</charge:amount><charge:amount command="transfer">20.0000</charge:amount><charge:amount command="update" name="restore">20.0000</charge:amount></charge:set></charge:trnData></extension>'.$TRID.'</response>'.$E2;
%price=(category => { name => 'AAAA', value => 'premium' },
        type => 'price',
        transfer => 20,
);
$rc=$dri->domain_transfer_start('85014aaaa.com',{duration=>$dri->local_object('duration',years => 1),auth=>{pw=>'2foo%BAR'},price=>\%price});
is_string($R1,$E1.'<command><transfer op="request"><domain:transfer xmlns:domain="urn:ietf:params:xml:ns:domain-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd"><domain:name>85014aaaa.com</domain:name><domain:period unit="y">1</domain:period><domain:authInfo><domain:pw>2foo%BAR</domain:pw></domain:authInfo></domain:transfer></transfer><extension><charge:agreement xmlns:charge="http://www.unitedtld.com/epp/charge-1.0" xsi:schemaLocation="http://www.unitedtld.com/epp/charge-1.0 charge-1.0.xsd"><charge:set><charge:category name="AAAA">premium</charge:category><charge:type>price</charge:type><charge:amount command="transfer">20</charge:amount></charge:set></charge:agreement></extension><clTRID>ABC-12345</clTRID></command>'.$E2,'domain_transfer_start build');
$data=$rc->get_data('domain','85014aaaa.com','price');
is_deeply($data->{category},{name => 'AAAA', value => 'premium'},'domain_transfer_start response category');
is($data->{type},'price','domain_transfer_start response type');
is($data->{create},20,'domain_transfer_start response create');
is($data->{renew},20,'domain_transfer_start response renew');
is($data->{transfer},20,'domain_transfer_start response transfer');
is($data->{'update.restore'},20,'domain_transfer_start response update.restore');



$R2=$E1.'<response>'.r().'<extension><rgp:upData xmlns:rgp="urn:ietf:params:xml:ns:rgp-1.0"><rgp:rgpStatus s="pendingRestore"/></rgp:upData><charge:upData xmlns:charge="http://www.unitedtld.com/epp/charge-1.0"><charge:set><charge:category name="AAAA">premium</charge:category><charge:type>price</charge:type><charge:amount command="create">20.0000</charge:amount><charge:amount command="renew">20.0000</charge:amount><charge:amount command="transfer">20.0000</charge:amount><charge:amount command="update" name="restore">20.0000</charge:amount></charge:set></charge:upData></extension>'.$TRID.'</response>'.$E2;
my $toc=Net::DRI::Data::Changes->new();
$toc->set('rgp',{ op => 'request'});
%price=(category => { name => 'AAAA', value => 'premium' },
        type => 'price',
        'update.restore' => 20,
);
$rc=$dri->domain_update('85014aaaa.com',$toc,{ price => \%price });
is_string($R1,$E1.'<command><update><domain:update xmlns:domain="urn:ietf:params:xml:ns:domain-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd"><domain:name>85014aaaa.com</domain:name></domain:update></update><extension><rgp:update xmlns:rgp="urn:ietf:params:xml:ns:rgp-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:rgp-1.0 rgp-1.0.xsd"><rgp:restore op="request"/></rgp:update><charge:agreement xmlns:charge="http://www.unitedtld.com/epp/charge-1.0" xsi:schemaLocation="http://www.unitedtld.com/epp/charge-1.0 charge-1.0.xsd"><charge:set><charge:category name="AAAA">premium</charge:category><charge:type>price</charge:type><charge:amount command="update" name="restore">20</charge:amount></charge:set></charge:agreement></extension><clTRID>ABC-12345</clTRID></command>'.$E2,'domain_update rgp build');
$data=$rc->get_data('domain','85014aaaa.com','price');
is_deeply($data->{category},{name => 'AAAA', value => 'premium'},'domain_update rgp response category');
is($data->{type},'price','domain_update rgp response type');
is($data->{create},20,'domain_update rgp response create');
is($data->{renew},20,'domain_update rgp response renew');
is($data->{transfer},20,'domain_update rgp response transfer');
is($data->{'update.restore'},20,'domain_update rgp response update.restore');

exit 0;
