## Domain Registry Interface, ARNES (.SI) EPP extensions
##
## Copyright (c) 2008,2009,2013,2016 Patrick Mevzek <netdri@dotandco.com>. All rights reserved.
##
## This file is part of Net::DRI
##
## Net::DRI is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## See the LICENSE file that comes with this distribution for more details.
####################################################################################################

package Net::DRI::Protocol::EPP::Extensions::ARNES;

use strict;
use warnings;

use Net::DRI::Data::Contact::ARNES;
use Net::DRI::Protocol::EPP::Extensions::ARNES::Status;
use base qw/Net::DRI::Protocol::EPP/;

=pod

=head1 NAME

Net::DRI::Protocol::EPP::Extensions::ARNES - ARNES (.SI) EPP extensions for Net::DRI

=head1 DESCRIPTION

Please see the README file for details.

=head1 SUPPORT

For now, support questions should be sent to:

E<lt>netdri@dotandco.comE<gt>

Please also see the SUPPORT file in the distribution.

=head1 SEE ALSO

E<lt>http://www.dotandco.com/services/software/Net-DRI/E<gt>

=head1 AUTHOR

Patrick Mevzek, E<lt>netdri@dotandco.comE<gt>

=head1 COPYRIGHT

Copyright (c) 2008,2009,2013,2016 Patrick Mevzek <netdri@dotandco.com>.
All rights reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

See the LICENSE file that comes with this distribution for more details.

=cut

####################################################################################################

sub setup
{
 my ($self,$rp)=@_;
 $self->ns({ dnssi => ['http://www.arnes.si/xml/epp/dnssi-1.2','dnssi-1.2.xsd'] });
 $self->factories('contact',sub { return Net::DRI::Data::Contact::ARNES->new(@_); });
 $self->capabilities('contact_update','disclose',['add','del']);
 $self->factories('status',sub { return Net::DRI::Protocol::EPP::Extensions::ARNES::Status->new(); });

 return;
}

sub core_contact_types { return ('admin','tech'); } ## No billing contact in .SI
sub default_extensions { return qw/ARNES::Contact ARNES::Domain/; }

####################################################################################################
1;
