#!/usr/local/bin/perl

=pod

=head1 CounterEspionage

version 1.0
by P.D. Magnus
pmagnus@fecundity.com
8/99
Copyright (c) 1999. All rights reserved.
This program is free software; you can redistribute it and/or modify it under the same terms as Perl itself.

CounterEspionage is a simple hit counter that makes use of the FontMonkey module.
Counters are stored in *.ce files in the directory given by $path.
It can take several items of input:

=over 4

=item rec

The script checks the .ce file specified by the value of rec.
If no value is given, it uses 'default.ce'.
It won't create counter files and returns 'err' if asked for a non-extant read-only counter.

=item noinc

Including 'noinc' in the query will return the counter without increasing the value.

=item dec

Including 'dec' in the query will decrease the counter by one.
If your anal-retentive about counting your own visits as hits on your site, you can use this to run the counter back down without having to edit the .ce file directly.
Overridden by 'noinc'.


=item font

This is passed on to FontMonkey.
If no font is given, it chooses one randomly.

=item layout

This is passed on to FontMonkey.
If none is given, output is horiz.

=back

Ex: <IMG SRC="yourcgi-bin/counter.pl?rec=foo&font=counter" ALT="many">

=cut

use FontMonkey::Image;
$LOCK_EX = 2;
$LOCK_UN = 8;
$path = "counters";

@fonts =
('basic',		#0
'digital',		#1
'typewriter',	#2
'counter',		#3
);

$line = $ENV{'QUERY_STRING'}.'&';

SWITCH: for ($line) {
	# determine the record
	/rec=(\w+)&/ ? ($rec = "$path/$1.ce") : ($rec = "$path/default.ce");

	# determine the increment flag
	/noinc&/ ? ($inc = 0) : /dec&/ ? ($inc = -1) : ($inc = +1);

	# determine the font
	/font=(\w+)&/ ? ($font = $1) : ($font = $fonts[int(rand($#fonts + 1))]);

	# determine the layout
	/layout=(\w+)&/ ? ($layout = $1) : ($layout = 'horiz');
}

# checkif the file is writable--
# the script won't create new counter files
if ( -w "$rec" ) {
	open (INFILE,"+<$rec");
	
	# lock, seek to beginning, get the contents
	flock(INFILE, $LOCK_EX);
	seek(INFILE, 0, 0); 	
	$num=<INFILE>;
	
	if ($inc) {
		# move back to beginning, increase the counter, print it
		seek(INFILE, 0, 0);
		$num += $inc;
		print INFILE "$num            ";
	}
	
	flock(INFILE, $LOCK_UN);
	$num =~ /([0-9]+)/;
	$num = $1;
}
else {
	$num = 'err';
}

(FontMonkey::Image->newmsg("$num", "$layout", "$font"))->render;
