BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( File::Glob File::Spec FindBin Term::ANSIColor strict warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.014; 1}) {
    print "Perl 5.014 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.33.
use strict;
use warnings;
use 5.014;
use ExtUtils::MakeMaker 6.64;
require "./inc/mymm.pl";

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Dist::Zilla plugin bundle used by Plicease",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.64"
  },
  "DISTNAME"         => "Dist-Zilla-PluginBundle-Author-Plicease",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.014",
  "NAME"             => "Dist::Zilla::PluginBundle::Author::Plicease",
  "PM"               => {
    "lib/Dist/Zilla/PluginBundle/Author/Plicease.pm" => "\$(INST_LIB)/Dist/Zilla/PluginBundle/Author/Plicease.pm"
  },
  "PREREQ_PM" => {
    "Dist::Zilla"                             => "6.00",
    "Dist::Zilla::App::Command::aliendeps"    => "0.01",
    "Dist::Zilla::Plugin::Alien"              => "0.023",
    "Dist::Zilla::Plugin::Author::Plicease"   => "2.33",
    "Dist::Zilla::Plugin::AutoMetaResources"  => "1.20",
    "Dist::Zilla::Plugin::CopyFilesFromBuild" => "0.150250",
    "Dist::Zilla::Plugin::InsertExample"      => "0.04",
    "Dist::Zilla::Plugin::InstallGuide"       => "1.200006",
    "Dist::Zilla::Plugin::MinimumPerl"        => "1.006",
    "Dist::Zilla::Plugin::OurPkgVersion"      => "0.12",
    "Dist::Zilla::Plugin::PodWeaver"          => "4.006",
    "Dist::Zilla::Plugin::ReadmeAnyFromPod"   => "0.150250",
    "Dist::Zilla::Plugin::Run::BeforeBuild"   => "0.035",
    "Dist::Zilla::Util::CurrentCmd"           => 0,
    "IPC::System::Simple"                     => "1.25",
    "Moose"                                   => 0,
    "Path::Tiny"                              => 0,
    "PerlX::Maybe"                            => "0.003",
    "Pod::Markdown"                           => "1.400",
    "Test::Fixme"                             => "0.14",
    "Test::Pod"                               => "1.48",
    "Test::Pod::Coverage"                     => "1.10",
    "Test::Script"                            => "1.10",
    "Test::Version"                           => "2.00",
    "YAML"                                    => "1.15"
  },
  "TEST_REQUIRES" => {
    "Test::More"   => "0.98",
    "Test::Script" => "1.10"
  },
  "VERSION" => "2.33",
  "test"    => {
    "TESTS" => "t/*.t"
    }
);

mymm::myWriteMakefile(%WriteMakefileArgs);