package Apps::Checkbook::Trans::Action;

use strict;

use base 'Apps::Checkbook';
use Apps::Checkbook::GEN::Trans::Action qw(
    form
);

use Gantry::Plugins::AutoCRUD qw(
    do_add
    do_edit
    do_delete
    form_name
);

use Apps::Checkbook::Model::trans qw(
    $TRANS
);

#-----------------------------------------------------------------
# $self->form( $row )
#-----------------------------------------------------------------
# This method supplied by Apps::Checkbook::GEN::Trans::Action


#-----------------------------------------------------------------
# get_model_name( )
#-----------------------------------------------------------------
sub get_model_name {
    return $TRANS;
}


1;

=head1 NAME

Apps::Checkbook::Trans::Action - A controller in the Apps::Checkbook application

=head1 SYNOPSIS

This package is meant to be used in the Perl block of an httpd.conf file.

    <Perl>
        # ...
        use Apps::Checkbook::Trans::Action;
    </Perl>

    <Location /someurl>
        SetHandler  perl-script
        PerlHandler Apps::Checkbook::Trans::Action
    </Location>

If all went well, the httpd.conf file was correctly written during app
generation.

=head1 DESCRIPTION

This module was originally generated by Bigtop.  But feel free to edit it.
You might even want to describe the table this module controls here.

=head1 METHODS

=over 4

=item get_model_name

=item text_descr

=back

=head1 METHODS MIXED IN FROM Apps::Checkbook::GEN::Trans::Action

=over 4

=item form

=back

=head1 DEPENDENCIES

    Apps::Checkbook
    Apps::Checkbook::GEN::Trans::Action
    Apps::Checkbook::Model::trans
    Gantry::Plugins::AutoCRUD

=head1 AUTHOR

Somebody Somewhere, E<lt>somebody@example.comE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2006 Somebody Somewhere

All rights reserved.

=cut
