package Apps::Checkbook;

use strict;

our $VERSION = '0.01';

use Gantry qw{ -Engine=MP20 -TemplateEngine=TT };

our @ISA = ( 'Gantry' );

use Apps::Checkbook::PayeeOr;
use Apps::Checkbook::Trans;
use Apps::Checkbook::Trans::Action;
use Apps::Checkbook::NoOp;

#-----------------------------------------------------------------
# $self->init( $r )
#-----------------------------------------------------------------
sub init {
    my ( $self, $r ) = @_;

    # process SUPER's init code
    $self->SUPER::init( $r );

    $self->DBName( $self->fish_config( 'DBName' ) || '' );
} # END init


sub DBName {
    my ( $self, $value ) = @_;

    if ( defined $value ) {
        $self->{DBName} = $value;
    }

    return $self->{DBName};
}

1;

=head1 NAME

Apps::Checkbook - the base module of this web app

=head1 SYNOPSIS

This package is meant to be used in the Perl block of an httpd.conf file.

    <Perl>
        # ...
        use Apps::Checkbook;
    </Perl>

If all went well, the httpd.conf file was correctly written during app
generation.

=head1 DESCRIPTION

This module was originally generated by Bigtop.  But feel free to edit it.
You might even want to describe the table this module controls here.

=head1 METHODS

=over 4

=item init

=item DBName

=back

=head1 SEE ALSO

    Gantry
    Apps::Checkbook::PayeeOr
    Apps::Checkbook::Trans
    Apps::Checkbook::Trans::Action
    Apps::Checkbook::NoOp

=head1 AUTHOR

Somebody Somewhere, E<lt>somebody@example.comE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2006 Somebody Somewhere

All rights reserved.

=cut
