# -*- perl -*-

require 5.008;
use strict;
require ExtUtils::MakeMaker;

eval { require 5.008 } or die << 'EOD';
#######################################
#	This module requires a minimum Perl version of 5.8.0
#	Please upgrade!
#######################################
EOD

unless ($^O eq 'MSWin32') {
	die <<'EOMSG';
#######################################
#	This module is only intended for Microsoft
#	Windows platforms.
#######################################
EOMSG
}

ExtUtils::MakeMaker::WriteMakefile(
	'NAME' => 'Win32::WindowGeometry',
	'VERSION_FROM' => 'lib/Win32/WindowGeometry.pm',
	'dist'         => { 
	 	'DIST_DEFAULT' => 'all tardist',
     	'SUFFIX'       => 'gz',
	 	'COMPRESS'     => 'gzip -9vf' 
	 },
   	'AUTHOR' => 'phatWares, USA (phatwares@gmail.com)',
   	'ABSTRACT' => 'Simple module to search for open windows by title and move/resize them',
   	'PREREQ_PM' => {
   		'Win32::API' => '0.0',
   		'Win32::API::Callback' => '0.0'
   	}
);
