#!/usr/bin/perl

use v5.14;
use warnings;

use Test2::V0;

use meta;

{
   my $metapkg = meta::get_package( "meta" );
   my $metaglob = $metapkg->get_glob( "get_package" );
   ok( $metaglob, '$metapkg->get_glob on get_package' );

   is( $metaglob->basename, "get_package",
      '$metaglob->basename' );
}

# missing
{
   my $metapkg = meta::get_package( "meta" );
   ok( !defined $metapkg->can_glob( "not-a-glob" ),
      'can_glob yields undef on missing glob' );

   like( dies { $metapkg->get_glob( "not-a-glob" ) },
      qr/^Package does not contain a glob called "not-a-glob" /,
      'get_glob throws on missing glob' );
}

done_testing;
