#!/usr/bin/perl

use strict;
use warnings;

use Test::More;

use Net::Prometheus;

my $client = Net::Prometheus->new;

ok( defined $client, 'defined $client' );

# initially empty
is( $client->render, "", '$client->render gives empty string' );

# with some metrics
{
   $client->new_gauge(
      name => "gauge",
      help => "A gauge metric",
   )->set( 123 );

   $client->new_counter(
      name => "counter",
      help => "A counter metric",
   )->inc();

   is( $client->render, <<'EOF', '$client->render gives metric results' );
# HELP gauge A gauge metric
# TYPE gauge gauge
gauge 123
# HELP counter A counter metric
# TYPE counter counter
counter 1
EOF
}

done_testing;
