#!/usr/bin/perl

use strict;
use warnings;

use Test::More;

use Net::Prometheus::Counter;

sub HASHfromSample
{
   my ( $sample ) = @_;
   return { map { $_, $sample->$_ } qw( varname labels value ) };
}

{
   my $counter = Net::Prometheus::Counter->new(
      name => "test_total",
      help => "A testing counter",
   );

   ok( defined $counter, 'defined $counter' );

   is_deeply( [ $counter->samples ], [],
      '$counter->samples initially'
   );

   $counter->inc;

   is_deeply( HASHfromSample( ( $counter->samples )[0] ),
      { varname => "test_total", labels => [], value => 1 },
      '$samples[0]'
   );
}

done_testing;
