#  You may distribute under the terms of either the GNU General Public License
#  or the Artistic License (the same terms as Perl itself)
#
#  (C) Paul Evans, 2020 -- leonerd@leonerd.org.uk

package Metrics::Any::Adapter;

use 5.010;  # //
use strict;
use warnings;

our $VERSION = '0.01';

sub import
{
   my $pkg = shift;
   my $caller = caller;
   $pkg->import_into( $caller, @_ );
}

my $default_adaptertype = "Null";

sub import_into
{
   my ( $pkg, $caller, $type ) = @_;

   $default_adaptertype = $type if defined $type;
}

my $adapter;

sub adapter
{
   shift;
   my ( @args ) = @_;

   warn "Too late to apply extra args" if @args and $adapter;

   return $adapter //= do {
      my $type = $default_adaptertype;
      my $class = "Metrics::Any::Adapter::$type";
      unless( $class->can( 'new' ) ) {
         ( my $file = "$class.pm" ) =~ s{::}{/}g;
         require $file;
      }
      $class->new( @args );
   };
}

0x55AA;
