#!/usr/bin/perl

use strict;
use warnings;

use Test::More;

BEGIN {
   plan skip_all => "Future is not available"
      unless eval { require Future };
   plan skip_all => "Future::AsyncAwait is not available"
      unless eval { require Future::AsyncAwait };
   plan skip_all => "Syntax::Keyword::Try >= 0.06 is not available"
      unless eval { require Syntax::Keyword::Try;
                    Syntax::Keyword::Try->VERSION( '0.06' ) };

   Future::AsyncAwait->import;
   Syntax::Keyword::Try->import;
}

# await in try/catch
{
   async sub with_trycatch
   {
      my $f = shift;

      my $ret;

      try {
         await $f;
         $ret = "result";
      }
      catch {
         $ret = "oopsie";
      }
      return $ret;
   }

   my $f1 = Future->new;
   my $fdone = with_trycatch( $f1 );

   $f1->done;
   is( scalar $fdone->get, "result", '$fdone for successful await in try/catch' );

   my $f2 = Future->new;
   my $ffail = with_trycatch( $f2 );

   $f2->fail( "fail" );
   is( scalar $ffail->get, "oopsie", '$ffail for failed await in try/catch' );
}

# await in try/catch with return
TODO: {
   local $TODO = "RT122795";

   async sub with_trycatch_return
   {
      my $f = shift;

      try {
         await $f;
         return "result";
      }
      catch {}
   }

   my $f1 = Future->new;
   my $fdone = with_trycatch_return( $f1 );

   my $ret;

   eval { $f1->done; $ret = $fdone->get; 1 } or do {
      my $e = $@; chomp $e;
      diag( "  Failed: $e" );
   };

   is( $ret, "result", '$fdone for successful await in try/catch with return' );
}

# await in try/finally
TODO: {
   local $TODO = "RT122796";

   async sub with_tryfinally
   {
      my $f = shift;

      my $ret = "";

      try {
         await $f;
         $ret .= "T";
      }
      finally {
         $ret .= "F";
      }

      return $ret;
   }

   my $f1 = Future->new;
   my $fret = with_tryfinally( $f1 );

   my $ret;

   eval { $f1->done; $ret = $fret->get; 1 } or do {
      my $e = $@; chomp $e;
      diag( "  Failed: $e" );
   };

   is( $ret, "TF", '$fret for await in try/finally' );
}

done_testing;
