#!/usr/bin/perl

use strict;
use warnings;

use Test::More;

use Future;

use Future::AsyncAwait;

# foreach(ARRAY) await
{
   my @F = map { Future->new } 1 .. 3;

   async sub with_foreach_array
   {
      foreach my $f ( @F ) {
         await $f;
      }
      return "end foreach";
   }

   my $fret = with_foreach_array();

   $F[0]->done;
   $F[1]->done;
   $F[2]->done;

   is( scalar $fret->get, "end foreach", '$fret now ready after foreach(ARRAY) loop' );
}

# foreach(LIST) await
{
   my @F = map { Future->new } 1 .. 3;

   async sub with_foreach_list
   {
      foreach my $f ( $F[0], $F[1], $F[2] ) {
         await $f;
      }
      return "end foreach";
   }

   my $fret = with_foreach_list();

   $F[0]->done;
   $F[1]->done;
   $F[2]->done;

   is( scalar $fret->get, "end foreach", '$fret now ready after foreach(LIST) loop' );
}

# foreach(LAZY IV) await
{
   my @F = map { Future->new } 1 .. 3;

   async sub with_foreach_lazy_iv
   {
      foreach my $idx ( 0 .. 2 ) {
         await $F[$idx];
      }
      return "end foreach";
   }

   my $fret = with_foreach_lazy_iv();

   $F[0]->done;
   $F[1]->done;
   $F[2]->done;

   is( scalar $fret->get, "end foreach", '$fret now ready after foreach(LAZY IV) loop' );
}

# foreach(LAZY SV) await
{
   my %F = map { $_ => Future->new } 'a' .. 'c';

   async sub with_foreach_lazy_sv
   {
      foreach my $key ( 'a' .. 'c' ) {
         await $F{$key};
      }
      return "end foreach";
   }

   my $fret = with_foreach_lazy_sv();

   $F{a}->done;
   $F{b}->done;
   $F{c}->done;

   is( scalar $fret->get, "end foreach", '$fret now ready after foreach(LAZY SV) loop' );
}

done_testing;
