#!/usr/bin/perl

use strict;
use warnings;

use Device::BusPirate;
use Getopt::Long;

GetOptions(
   's|set-to-now' => \my $SET_TO_NOW,
) or exit 1;

my $pirate = Device::BusPirate->new;
my $chip = $pirate->mount_chip( "DS1307" )->get;

$chip->power(1)->get;

$SIG{INT} = $SIG{TERM} = sub { exit 1; };

END {
   $chip and $chip->power(0)->get;
   $pirate and $pirate->stop;
}

if( $SET_TO_NOW ) {
   $chip->write_time( localtime )->get;
}

use POSIX qw( mktime );
print "The time on the DS1307 is ",
   scalar( localtime mktime $chip->read_time->get ),
   "\n";
