package API::MailboxOrg::API::Account;

# ABSTRACT: MailboxOrg::API::Account

# ---
# This class is auto-generated by bin/get_mailbox_api.pl
# ---

use v5.24;

use strict;
use warnings;

use Moo;
use Types::Standard qw(Enum Str Int);
use Params::ValidationCompiler qw(validation_for);

extends 'API::MailboxOrg::APIBase';

with 'MooX::Singleton';

use feature 'signatures';
no warnings 'experimental::signatures';

our $VERSION = '1.0.0'; # VERSION

my %validators = (
    'add' => validation_for(
        params => {
            account      => { type => Str, optional => 0 },
            password     => { type => Str, optional => 0 },
            plan         => { type => Enum[qw(basic profi profixl reseller)], optional => 0 },
            tarifflimits => { type => Str, optional => 1 },
            memo         => { type => Str, optional => 1 },

        },
    ),
    'del' => validation_for(
        params => {
            account => { type => Str, optional => 0 },

        },
    ),
    'get' => validation_for(
        params => {
            account => { type => Str, optional => 0 },

        },
    ),
    'set' => validation_for(
        params => {
            account                    => { type => Str, optional => 0 },
            password                   => { type => Str, optional => 1 },
            plan                       => { type => Enum[qw(basic profi profixl reseller)], optional => 1 },
            memo                       => { type => Str, optional => 1 },
            address_payment_first_name => { type => Str, optional => 1 },
            address_payment_last_name  => { type => Str, optional => 1 },
            address_payment_street     => { type => Str, optional => 1 },
            address_payment_zipcode    => { type => Str, optional => 1 },
            address_payment_town       => { type => Str, optional => 1 },
            av_contract_accept_name    => { type => Str, optional => 1 },
            tarifflimits               => { type => Str, optional => 1 },

        },
    ),

);


sub add ($self, %params) {
    my $validator = $validators{'add'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'account.add', \%params, \%opt );
}

sub del ($self, %params) {
    my $validator = $validators{'del'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'account.del', \%params, \%opt );
}

sub get ($self, %params) {
    my $validator = $validators{'get'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'account.get', \%params, \%opt );
}

sub list ($self, %params) {
    my $validator = $validators{'list'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'account.list', \%params, \%opt );
}

sub set ($self, %params) {
    my $validator = $validators{'set'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'account.set', \%params, \%opt );
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

API::MailboxOrg::API::Account - MailboxOrg::API::Account

=head1 VERSION

version 1.0.0

=head1 SYNOPSIS

    use API::MailboxOrg;

    my $user     = '1234abc';
    my $password = '1234abc';

    my $api      = API::MailboxOrg->new(
        user     => $user,
        password => $password,
    );

=head1 METHODS

=head2 add

Creates a new account

Available for reseller

Parameters:

=over 4

=item * account

=item * password

=item * plan

=item * tarifflimits

=item * memo

=back

returns: array

    $api->account->add(%params);

=head2 del

Deletes an existing account

Available for admin, reseller

Parameters:

=over 4

=item * account

=back

returns: boolean

    $api->account->del(%params);

=head2 get

Returns information about an account

Available for admin, reseller, account

Parameters:

=over 4

=item * account

=back

returns: array

    $api->account->get(%params);

=head2 list

Returns a list of all accounts that can be administrated

Available for admin, reseller

returns: array

    $api->account->list(%params);

=head2 set

Eigenschaften eines Accounts verändern

Available for admin, reseller

Parameters:

=over 4

=item * account

=item * password

=item * plan

=item * memo

=item * address_payment_first_name

=item * address_payment_last_name

=item * address_payment_street

=item * address_payment_zipcode

=item * address_payment_town

=item * av_contract_accept_name

=item * tarifflimits

=back

returns: array

    $api->account->set(%params);

=head1 AUTHOR

Renee Baecker <reneeb@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2022 by Renee Baecker.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
